; $Id: dm_q2hkl.pro,v 1.11 2015/09/16 17:23:05 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_q2hkl
;
; PURPOSE:
;  project Q[3,ne,ndet] onto three vectors abc_r[3,3]
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  August, 2015
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

;keyword:
;  no_copy:     if set, Q will be erased to save memory
;  n_fold:      symmetry rotation fold, 
;  sr_type:     combined with n_fold for symmetry rotation type 0-rotate to the first section(default), 1-rotate to the first quadrant
;  sr_startvec: combined with sr_type=0, the angle of the starting vector with respect to u1.
function dm_q2hkl,Q,abc_r,no_copy=no_copy,n_fold=n_fold,sr_type=sr_type,sr_startvec=sr_startvec,debug=debug
    if keyword_set(debug) then begin
       print,'%%Q to hkl...'
       current=systime(/sec)
    endif
    if n_elements(n_fold) ne 0 then fold = (1>(fix(n_fold))) else fold = 1  
    ABC   = transpose(dm_basis_hkl(abc_r))
    Qsize = size(Q,/dimension)
    if keyword_set(no_copy) then begin
       tmp = temporary(Q)
       tmp = reform(tmp,3,n_elements(tmp)/3,/overwrite)
    endif else begin
       tmp = reform(Q,3,n_elements(Q)/3)
    endelse
    if fold gt 1 then begin   
       fold_ang = 2*!pi/fold
       sinpsi   = sin(fold_ang)
       cospsi   = cos(fold_ang)
       R        = [[cospsi,-sinpsi,0.0],[sinpsi,cospsi,0.0],[0.0,0.0,1.0]]
       if keyword_set(sr_type) then begin                   ;rotate to the first quadrant
          tmp_a = ABC
       endif else begin                                     ;rotate to the first symmetric section
          tmp_u = abc_r[*,0]                                ;u axis Q
          tmp_v = abc_r[*,1]                                ;v axis Q
          tmp_w = abc_r[*,2]                                ;w axis Q
          sign0 = tmp_u[0]*tmp_v[1]-tmp_u[1]*tmp_v[0]
          if sign0 gt 0 then R = transpose(R)               ;v axis above u     
          if fold eq 2  then R = transpose(R)
          if keyword_set(sr_startvec) then begin
             sintmp = sin(sr_startvec*!dtor)
             costmp = cos(sr_startvec*!dtor)
             Rtmp   = transpose([[costmp,-sintmp,0.0],[sintmp,costmp,0.0],[0.0,0.0,1.0]])
             tmp_u  = tmp_u##Rtmp
          endif
          tmp_v = tmp_u##R
          tmp_a = transpose(dm_basis_hkl([[tmp_u],[tmp_v],[tmp_w]]))
       endelse 
       hkl  = tmp##tmp_a
       nrot = 0
       repeat begin
          index = where(hkl[1,*] lt 0,count)
          if count ne 0 then begin
             tmp[*,index] = tmp[*,index]##R
             hkl[*,index] = tmp[*,index]##tmp_a
          endif
          nrot = nrot+1
       endrep until (count eq 0) or (nrot eq fold)       
       R    = transpose(R) 
       nrot = 0
       repeat begin
          index = where(hkl[0,*] lt 0,count)
          if count ne 0 then begin
             tmp[*,index] = tmp[*,index]##R
             hkl[*,index] = tmp[*,index]##tmp_a
          endif
          nrot = nrot+1
       endrep until (count eq 0) or (nrot eq fold)
       if ~keyword_set(sr_type) then hkl = tmp##ABC
    endif else begin
       hkl = tmp##ABC
    endelse
    tmp = 0
    hkl = reform(hkl,Qsize,/overwrite)
    if keyword_set(debug) then begin
       print,'%%Q to hkl finished in ',systime(/sec)-current,' sec.'
    endif 
    return,hkl
end