; $Id: dm_plot_cut.pro,v 1.35 2017/03/16 19:34:56 ymqiu Exp $
;#######################################################################
;
; NAME:
;  dm_plot_cut
;
; PURPOSE:
;  plot the cut and save the data in a file if wanted
;
; CATEGORY:
;  dcs_mslice
;
; AUTHOR:
;  Yiming Qiu
;  NIST Center for Neutron Research
;  100 Bureau Drive, Gaithersburg, MD 20899-6102
;  United States
;  yiming.qiu@nist.gov
;  May, 2025
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;#######################################################################

pro dcs_mslice::dm_plot_cut,overplot=overplot
    if (~self->pd_valid()) then return
    WIDGET_CONTROL,/HOURGLASS
    
    ;select data
    if (~self.errbar) or ((self.samp_typ ge 0) and self.absp_asint) then $
       self->dm_choose_cutdata,xdat=xdat,ydat=ydat,xtit=xtit,ytit=ytit,is_E_t=is_E_t,error=error,extra_tit=extra_tit,extra_legd=extra_legd $
    else $
       self->dm_choose_cutdata,xdat=xdat,ydat=ydat,yerr=yerr,xtit=xtit,ytit=ytit,is_E_t=is_E_t,error=error,extra_tit=extra_tit,extra_legd=extra_legd
    if keyword_set(error) then return

    ;extra info in the title and legend
    if (strlen(self.titl_lab) eq 0) or (strlen(extra_tit) eq 0) then sep='' else sep=', '
    title  = self.titl_lab+sep+extra_tit
    if (strlen(self.legd_lab) eq 0) or (strlen(extra_legd) eq 0) then sep='' else sep=', '
    legd   = self.legd_lab+sep+extra_legd
    symbol = (*self.symbols)[self.cut_symbol]
    lstyle = (*self.lines)[self.cut_line]
    lcolor = (*self.colors)[self.cut_color]

    ;plot the data
    isnew = 0b
    if self.useitool then begin
       ok = dialog_message('Itools plotting is not implemented yet. Soooorry!',dialog_parent=self.tlb)
       return
    endif else begin
       self.current = self->searchcurrent(crossplot=crossplot,keep=keep)
       if (~obj_valid(self.current)) or (keyword_set(crossplot) and (~keyword_set(overplot))) or keyword_set(keep) then begin
          self.current = obj_new('dm_plot',xdat,ydat,yerr=yerr,xtit=xtit,ytit=ytit,xsize=(*self.pdim_list)[0,self.pdim_choice],ysize=(*self.pdim_list)[1,self.pdim_choice],$
                parentobj=self,/isolatin1,linestyle=lstyle,psym=symbol,color=lcolor,path=self.dirs[1],xran=self.cut_ran,yran=self.cut_yran,title=title,/no_copy,legend=legd,$
                background=(['black','white'])[self.pbgcol_bw],vt_col=self.ppvc_choice,notooltip=self.pnotooltip,coldefine=self.coldefine,render_method=self.ptrm_choice,$
                tickdir=self.tdir_choice,gridontop=0,wtitle='Cut')
          isnew = 1b & crossplot = 0b
       endif else begin
          if keyword_set(overplot) then $
             self.current->add_plot,xdat,ydat,yerr=yerr,/no_copy,legend=legd,coldefine=self.coldefine,color=lcolor,psym=symbol,linestyle=lstyle $
          else $
             self.current->setproperty,xdat=xdat,ydat=ydat,yerr=yerr,xtit=xtit,/no_copy,legend=legd,ytit=ytit,xran=self.cut_ran,yran=self.cut_yran,color=lcolor,coldefine=self.coldefine,$
                psym=symbol,linestyle=lstyle,title=title,/nodraw,hidelegend=0,bgcolor=self.pbgcol_bw,vt_col=self.ppvc_choice,tickdir=self.tdir_choice,gridontop=0,wtitle='Cut'
       endelse
       ;add powder lines in powder mode
       if (self.samp_typ eq 0) and ptr_valid(self.powd_line) and (isnew or (~keyword_set(overplot))) then begin
          tmp = size(*self.powd_line)
          if tmp[0] eq 2 then tmp=1 else tmp=tmp[tmp[0]] 
          if self.cut_x[0] eq 1 then begin  ;x-axis is Q
             ;make sure elastic peak is in there
             if self.cut_t1[0] eq 0 then begin
                maxE = max((*self.projStrPtr).en,min=minE)
                eran = [minE,maxE]
                if finite(self.cut_t1ran[0]) then eran[0] = self.cut_t1ran[0]
                if finite(self.cut_t1ran[1]) then eran[1] = self.cut_t1ran[1]
                if (eran[0] le 0) and (eran[1] ge 0) then ix = 0
             endif
          endif
          if n_elements(ix) ne 0 then $
             for i=0,tmp-1 do $
                 self.current->add_plot,(*self.powd_line)[*,ix,i],(*self.powd_line)[*,1-ix,i],psym='no symbol',color='dark yellow',linestyle='dashed',layer=i,$
                        legend=(['',(['Al','Cu','Stainless Steel','Specified'])[(self.powd_typ-1)>0]+' powder line'])[i eq 0]
       endif
       if obj_valid(self.current) then self.current->draw else return
    endelse
    
    if ~keyword_set(crossplot) then begin
       title = ((strlen(self.titl_lab) eq 0)?ytit+' vs. '+xtit:title)
       if keyword_set(overplot) and (~isnew) then $
          self->dm_add_plotwindow,type=1,title=title+'[overplot]' $
       else $
          self->dm_add_plotwindow,type=1,title=title
    endif
end