; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
function dcs_jcc_resn_Ruep,wli,wlf,delta_tp,delta_tm,d_pm,d_sd,d_ms,delta_l_s,delta_l_det,eifwhm=eifwhm
;************************************************************************************************
;
compile_opt strictarr
;
; Lechner's formula
; wli,wlf, incident/final wavelength (A)
; delta_tp, delta_tm   P and M chopper burst times in us
; d_pm P-M chopper separation (mm)
; d_sd  sample-detector separation (mm)
; d_ms M chopper-sample separation (mm)
; delta_l_s uncertainty in sample-detector distance (mm)
; delta_l_det uncertainty in detector neutron capture depth
; delta_t in us
;
; Convert distances to meters
delta_l_s_m = delta_l_s * 0.001
delta_l_det_m = delta_l_det * 0.001
d_pm_m = d_pm * 0.001
d_sd_m = d_sd * 0.001
d_ms_m = d_ms * 0.001
;
delta_l = sqrt(delta_l_s_m^2 + delta_l_det_m^2)
;
a = 252.77 * delta_l * d_pm_m * wlf
b = delta_tp * (d_ms_m + (d_sd_m * (wlf/wli)^3))
c = delta_tm * (d_pm_m + d_ms_m + (d_sd_m * (wlf/wli)^3))
;
res_inel = 647.2 * sqrt(a^2 + b^2 + c^2) / (d_pm_m * d_sd_m * wlf^3)
eifwhm = 647.2 * sqrt(delta_tp^2 + delta_tm^2)/(d_pm_m  *  wli^3)
return,res_inel
end



;************************************************************************************************
function dcs_jcc_resn,wli,wlf,rmode,mspeed,eifwhm=eifwhm
;************************************************************************************************
;
compile_opt strictarr
;
; DCS resolution
;
case rmode of
	1:	begin & a_tp=1.4e6 & a_tm=7.2e5 & Wg=30 & end
	2:	begin & a_tp=7.8e5 & a_tm=2.9e5 & Wg=15 & end
	3:	begin & a_tp=3.3e5 & a_tm=1.3e5 & Wg= 5 & end
	else:
endcase
delta_tp=a_tp/mspeed
delta_tm=a_tm/mspeed
;
d_pm=9004.0
d_sd=4010.0
d_ms=1500.0
;
delta_l_s=Wg
;
delta_l_det=10.9 < 1/(0.044*wlf)
;
res=dcs_jcc_resn_Ruep(wli,wlf,delta_tp,delta_tm,d_pm,d_sd,d_ms,delta_l_s,delta_l_det,eifwhm=eifwhm)
; JRDC believes the following two lines should be omitted so they have been commented out.
;res=res*(20000./mspeed)
;eifwhm=eifwhm*(20000./mspeed)
;
return,res
end