; $Id$
; Written by J.R.D. Copley.
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
function dcs_jcc_flux,wl,rmode,npsptr
;************************************************************************************************
;
compile_opt strictarr
;
; DCS beam area-averaged flux at 20000 rpm with SR=1.
;
vals=(*npsptr).(rmode-1)
wls=vals[0,*]
nps=vals[1,*]
nwls=n_elements(wls)
minwls=wls[0]
maxwls=wls[nwls-1]
;
nwl=n_elements(wl)
flux=fltarr(nwl)
for i=0,nwl-1 do begin
	flux[i]=0.0
	if (wl[i] ge minwls and wl[i] le maxwls) then flux[i]=interpol(nps,wls,wl[i])
endfor
;
return,flux
end