; $Id$
;************************************************************************************************
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
function dcs_getctinfo,index
;************************************************************************************************
; Gets current color table information.
; If called with getctinfo() or getctinfo(n) with n<0 it returns a 256x3 array.
; If called with getctinfo(n) where 0 <= n <= 255, it returns a 3-vector.
; Otherwise it returns 999 (error value).
;
compile_opt strictarr
;
tvlct,r,g,b,/get
if (n_params() eq 0) then return,[[r],[g],[b]]
if (n_params() eq 1 and index ge 0 and index le 255) then $
	return,[r[index],g[index],b[index]]
return,999
end