; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEwriteDAVE1
;
; PURPOSE:
;   File writer for DAVE 1.x data files
;
; CATEGORY:
;   Input Output
;
; SUPERCLASSES:
;   IDLitWriter
;
; SUBCLASSES:
;
; CREATION:
;   See DAVEwriteDAVE1::Init
;
; METHODS:
;   SetData
;
; INTERFACES:
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; April 2006
;-
;###############################################################################


;===============================================================================
; DAVEwriteDAVE1::SetData
; 
; PURPOSE:
;   Responsible for actually writing the data to file
;
; PARAMETERS:
;   oData [in] - the data to be saved
;
; KEYWORDS:
;   none
;
; RETURN VALUE:
;    1 - Successful Write
;    0 - Failure.
function DAVEwriteDAVE1::SetData, oData
compile_opt idl2

myTitle = 'Save as DAVE 1.x file'
if (~obj_valid(oData) || n_elements(oData) lt 1) then begin
    self->SignalError,['No selected data','Cannot proceed with save!'] $
                        , severity=2
    return, 0
endif

if (self->getFilename() eq '') then begin
    self->SignalError,['No output filename specified','Cannot proceed with save!'] $
                        , severity=2
    return, 0
endif


;if (self->getDavePtr(davePtr, oData)) then begin
;   filename = self->GetFilename()
;   save, davePtr, /compress, filename=filename   
;;    self->ErrorMessage,['Output saved to',filename], title=myTitle, severity=0
;   heap_free, davePtr
;   
;   return, 1
;endif else $
;   return, 0
errormsg = ''
if (obj_hasmethod(oData,'toDAVEPtr')) then begin
   if (oData->toDAVEPtr(davePtr, errormsg) && ptr_valid(davePtr)) then begin
      filename = self->GetFilename()
      save, davePtr, /compress, filename=filename
      heap_free, davePtr
      return, 1
   endif else begin
      msg = (errormsg eq '')? ["Failure to convert to DAVE format"] : errormsg
      ;Self->ErrorMessage, msg, title=myTitle, severity=2
      Self->SignalError, msg, severity=2
      return, 0
   endelse
endif else begin
   msg = ['Unknown dataset type!',"Cannot convert to DAVE format"]
   ;Self->ErrorMessage, msg, title=myTitle, severity=2
   Self->SignalError, msg, severity=2
   return, 0
endelse

end


;;===============================================================================
;; DAVEwriteDAVE1::isValid
;; 
;; PURPOSE:
;;   Validate data object
;;
;; PARAMETERS:
;;   oData [in] - The data object to be validated
;;
;;   validType [in] - The appropriate type
;;
;; KEYWORDS:
;;   none
;;
;; RETURN VALUE:
;;    1 - Valid
;;    0 - Invalid.
;function DAVEwriteDAVE1::isValid, oData, validType
;compile_opt idl2
;
;;
;if (~obj_valid(oData)) then return, 0
;
;; Must be of type DAVE1DATASET
;oData->getProperty, type=type
;return, type eq validType
;
;end
;
;
;;===============================================================================
;; DAVEwriteDAVE1::datasetType
;; 
;; PURPOSE:
;;   Return the dataset type for the input dataset
;;
;; PARAMETERS:
;;   oData [in] - The data object whose type is required
;;
;; KEYWORDS:
;;   none
;;
;; RETURN VALUE:
;;    1 - Valid
;;    0 - Invalid.
;function DAVEwriteDAVE1::datasetType, oData
;compile_opt idl2
;
;if ((n_elements(oData) eq 0) || ~obj_valid(oData)) then return, ''
;
;oData->getProperty, type=type
;return, type 
;
;end
;
;
;;===============================================================================
;; DAVEwriteDAVE1::getDAVEPtr
;; 
;; PURPOSE:
;;   Private function for converting an object hierarchy consisting of
;;   IDLitDataContainer and/or IDLitData ojects into a davePtr
;;   structure.
;;
;; PARAMETERS
;;   davePtr [out] - The davePtr structure.
;;
;;   oData [in] - The data object containing data to be saved
;;
;; KEYWORDS:
;;
;; RETURN VALUE:
;;    1 - If successful.
;;    0 - If unsuccessful.
;;
;function DAVEwriteDAVE1::getDavePtr, davePtr, oData
;compile_opt idl2
;
;retVal = 1
;myTitle = 'Save as DAVE 1.x file'
;
;
;switch self->datasetType(oData) of
;   'DAVE1DATASET': begin
;
;      ;; Get the top level contents of dataset
;      cont = oData->Get(/all,count=cnt)
;      if (cnt lt 1) then  begin
;         self->ErrorMessage,['Empty dataset!','Cannot write selected dataset'] $
;                            ,title=myTitle
;         return, 0
;      endif
;      
;      for i=0,cnt-1 do begin
;         if (retVal eq 0) then continue
;         
;         cont[i]->getProperty, type=type
;         ;;    help,'****** type=',type
;         case type of
;            'DAVE1INST': begin
;               res = cont[i]->getData(inst)
;               ;;            help,inst
;            end
;            
;            'DAVE1HISTORY': begin
;               res = cont[i]->getData(trmt)
;                                ;            help,trmt
;            end
;            
;            'DESCRIPTR': begin
;               obj = cont[i]->getByName('Value')
;               if ((retVal = obj_valid(obj)) eq 0) then break
;               obj->getProperty, name=dptrName
;               void = obj->getData(dptrQty)
;               obj = cont[i]->getByName('Description')
;               void = obj->getData(dptrDesc)
;               obj = cont[i]->getByName('Error')
;               void = obj->getData(dptrErr)
;               obj = cont[i]->getByName('Units')
;               void = obj->getData(dptrUnits)
;            end
;
;            'DAVE1COMMONSTR': begin
;               ;; 
;               obj = cont[i]->getByName('2') ; the dependent axis
;               if ((retVal = obj_valid(obj)) eq 0) then begin
;                  msg = ['Incomplete dataset!','Cannot write selected dataset']
;                  self->ErrorMessage, msg,title=myTitle
;                  return, 0
;               endif
;               void = obj->getData(qty)
;               if ((void = obj->GetMetaData('Long_name',qtyLabel)) eq 0 ) then qtyLabel=''
;               if ((void = obj->GetMetaData('Units',qtyUnits)) eq 0 ) then qtyUnits=''
;               if ((void = obj->GetMetaData('Axes',axes)) eq 0 ) then axes=''
;               
;               obj = cont[i]->getByName('3') ; the error in the dependent axis
;               if (obj_valid(obj)) then $
;                  void = obj->getData(err)
;               
;               obj = cont[i]->getByName('0') ; first independent axis
;               if (obj_valid(obj)) then begin
;                  void = obj->getData(xdata)
;                  if ((void = obj->GetMetaData('Long_name',xLabel)) eq 0 ) then xLabel=''
;                  if ((void = obj->GetMetaData('Units',xUnits)) eq 0 ) then xUnits=''
;                  if ((void = obj->GetMetaData('Distribution',xType)) eq 0 ) then xType='POINTS'
;                  ;;            if (strcmp(xType,'HISTOGRAM',/fold_case)) then xType = 'HISTO' 
;               endif
;               
;               if (n_elements(axes) eq 2) then begin
;                  obj = cont[i]->getByName('1') ; second independent axis
;                  if (obj_valid(obj)) then begin
;                     void = obj->getData(ydata)
;                     if ((void = obj->GetMetaData('Long_name',yLabel)) eq 0 ) then yLabel=''
;                     if ((void = obj->GetMetaData('Units',yUnits)) eq 0 ) then yUnits=''
;                     if ((void = obj->GetMetaData('Distribution',yType)) eq 0 ) then yType='POINTS'
;                                ;if (strcmp(yType,'HISTOGRAM',/fold_case)) then yType = 'HISTO' 
;                  endif
;               endif
;            end
;            
;            'DAVE1SPECIFICPTR': begin
;               retVal = self->ObjectToSpecificStr(specificStr, cont[i])
;            end
;            
;            else:
;         endcase
;      endfor
;
;      break
;   end
;   
;   'ASCIISPE': 
;   'ASCIIGRP': 
;   'ASCIICOL': begin
;
;      ;; Get the top level contents of dataset
;      void = oData->Get(/all,count=cnt)
;      if (cnt lt 1) then  begin
;         self->ErrorMessage,['Empty dataset!','Cannot write selected dataset'] $
;                            ,title=myTitle
;         return, 0
;      endif
;
;      obj = oData->getByName('2') ; the dependent axis
;      if ((retVal = obj_valid(obj)) eq 0) then break
;      void = obj->getData(qty)
;      if (n_elements(qty) le 0) then begin
;         msg = ['Incomplete dataset!','Cannot write selected dataset']
;         self->ErrorMessage, msg,title=myTitle
;         return, 0
;      endif
;      if ((void = obj->GetMetaData('Long_name',qtyLabel)) eq 0 ) then qtyLabel=''
;      if ((void = obj->GetMetaData('Units',qtyUnits)) eq 0 ) then qtyUnits=''
;      if ((void = obj->GetMetaData('Axes',axes)) eq 0 ) then axes=''
;      
;      obj = oData->getByName('3') ; the error in the dependent axis
;      if (obj_valid(obj)) then $
;         void = obj->getData(err)
;      
;      obj = oData->getByName('0') ; first independent axis
;      if (obj_valid(obj)) then begin
;         void = obj->getData(xdata)
;         if (n_elements(xData) le 0) then begin
;            retVal = 0
;            break
;         endif
;         if ((void = obj->GetMetaData('Long_name',xLabel)) eq 0 ) then xLabel=''
;         if ((void = obj->GetMetaData('Units',xUnits)) eq 0 ) then xUnits=''
;         if ((void = obj->GetMetaData('Distribution',xType)) eq 0 ) then xType='POINTS'
;      endif else begin
;         msg = ['Incomplete dataset!','Cannot write selected dataset']
;         self->ErrorMessage, msg,title=myTitle
;         return, 0
;      endelse
;      
;      if (n_elements(axes) eq 2) then begin
;         obj = oData->getByName('1') ; second independent axis
;         if (obj_valid(obj)) then begin
;            void = obj->getData(ydata)
;            if (n_elements(yData) le 0) then begin
;               msg = ['Incomplete dataset!','Cannot write selected dataset']
;               self->ErrorMessage, msg,title=myTitle
;               return, 0
;            endif
;            if ((void = obj->GetMetaData('Long_name',yLabel)) eq 0 ) then yLabel=''
;            if ((void = obj->GetMetaData('Units',yUnits)) eq 0 ) then yUnits=''
;            if ((void = obj->GetMetaData('Distribution',yType)) eq 0 ) then yType='POINTS'
;         endif
;      endif
;      
;      break
;   end
;
;   else: begin
;      self->ErrorMessage,['Invalid dataset!','Cannot write selected dataset'] $
;                         ,title=myTitle
;      return, 0
;   end
;
;endswitch
;
;
;
;
;if (retVal ne 0) then $
;  retVal = create_dave_pointer(davePtr $
;                           ,instrument = inst	$
;                           ,qty = qty $
;                           ,qtunits = qtyUnits $
;                           ,qtlabel = qtyLabel $
;                           ,err = err $
;                           ,xvals = xdata $
;                           ,xtype = xtype $
;                           ,xunits = xunits $
;                           ,xlabel = xlabel $
;                           ,yvals = ydata $
;                           ,ytype = ytype $
;                           ,yunits = yunits $
;                           ,ylabel = ylabel $
;                           ,specificstr = specificstr $
;                           ,treatment = trmt $
;                           ,dname = dptrName $
;                           ,dunits = dptrUnits $
;                           ,dlegend = dptrDesc $
;                           ,dqty = dptrQty $
;                           ,derr = dptrErr $
;                           ,ermsg = errmsg $
;                          )
;
;if (retVal eq 0) then begin
;    ;; cleanup before returning
;   if (n_elements(specificStr) gt 0) then heap_free, specificStr
;   if (ptr_valid(davePtr)) then heap_free, davePtr
;endif
;
;return, retVal
;
;end
;
;
;
;;===============================================================================
;; DAVEwriteDAVE1::ObjectToSpecificStr
;; 
;; PURPOSE:
;;   Convert contents of an IDLitData/Container object into a data structure.
;;
;; PARAMETERS
;;   dataStr [out] - The data structure
;;
;;   obj [in] - The data object
;;
;; KEYWORDS:
;;
;; RETURN VALUE:
;;    1 - success
;;    0 - failure
;;
;function DAVEwriteDAVE1::ObjectToSpecificStr, dataStr, obj
;compile_opt hidden
;
;if (~obj_valid(obj)) then return, 0
;
;obj->getProperty, type=type, name=tag
;
;switch type of
;    '': break
;
;    'STRUCT':
;    'DAVE1SPECIFICPTR':
;    'POINTER': begin
;        if (obj_isa(obj,'IDL_CONTAINER')) then begin
;            cont = obj->get(/all,count=cnt)
;            if (cnt eq 0) then break 
;            for i = 0,cnt-1 do retVal = self->ObjectToSpecificStr(dataStr,cont[i])
;            
;            
;            ;; store in heap if required
;            tmpStr = (type eq 'POINTER')? ptr_new(dataStr) : dataStr
;
;            if (type ne 'DAVE1SPECIFICPTR') then $
;              dataStr = (n_elements(dataStr) eq 0)? $
;                        create_struct(tag,tmpStr) : $
;                        create_struct(dataStr,tag,tmpStr)
;            
;            
;        endif else begin
;            if (~obj->getData(value)) then break
;            if (type ne 'STRUCT') then  $
;              value = ptr_new(value)
;            
;            dataStr = (n_elements(dataStr) eq 0)? $
;                      create_struct(tag,value) : $
;                      create_struct(dataStr,tag,value)
;            
;        endelse
;        
;        break
;    end
;    
;    else: begin
;        if (obj_isa(obj,'IDLITDATA')) then begin        
;            if (~obj->getData(value)) then break
;            obj->GetProperty, extraType=extraType   ;   only defined for IDLitDataDave (subclass of IDLitData) objects
;            if (n_elements(extraType) eq 0) then extraType=''
;            if (strcmp(extraType,'POINTER')) then value=ptr_new(value)   ; => value was originally a heap var!
;            dataStr = (n_elements(dataStr) eq 0)? $
;                      create_struct(tag,value) : $
;                      create_struct(dataStr,tag,value)
;        endif else if (obj_isa(obj,'IDL_CONTAINER')) then begin
;            cont = obj->get(/all,count=cnt)
;            for i = 0,cnt-1 do retVal = self->ObjectToSpecificStr(dataStr,cont[i])
;        endif
;;        if (obj_isa(obj,'IDLITDATA')) then begin        
;;            if (~obj->getData(value)) then break
;;            dataStr = (n_elements(dataStr) eq 0)? $
;;                      create_struct(tag,value) : $
;;                      create_struct(dataStr,tag,value)
;;        endif else if (obj_isa(obj,'IDL_CONTAINER')) then begin
;;            cont = obj->get(/all,count=cnt)
;;            for i = 0,cnt-1 do retVal = self->ObjectToSpecificStr(dataStr,cont[i])
;;        endif
;        
;        break
;    end
;    
;endswitch
;
;return, 1
;end



;===============================================================================
; DAVEwriteDAVE1::Init
; 
; PURPOSE:
;   Initialization method for objects of DAVEwriteDAVE1 class
;
; PARAMETERS
;
; KEYWORDS:
;
; RETURN VALUE:
;    1 - Successful
;    0 - Failure
;
function DAVEwriteDAVE1::init, _REF_EXTRA=etc
compile_opt idl2

; Init superclass
if (self->IDLitWriter::Init('dave' $
                            ,TYPES="DAVE1x" $ ; not data types but writer types! B/c not dependent on vis data.
                            ,NAME="DAVE 1.x" $
                            ,DESCRIPTION="DAVE 1.x data file (dave)" $
                            ,_EXTRA=etc) eq 0) then $
                              return, 0

; call setproperty method, if necessary.
if (n_elements(etc) gt 0) then $
  self->SetProperty, _EXTRA=etc

return, 1

end




;===============================================================================
pro DAVEwriteDAVE1__Define
compile_opt idl2

void = {DAVEwriteDAVE1, $
        inherits IDLitWriter $
       }
end
