

;===============================================================================
; Purpose:
;   Internal method to determine if the data is in vector format.
;
;function DAVEreadAscii::_HandleVectorData, $
;  sData, name, description, oData
;
;compile_opt idl2, hidden
;
;nFields = N_TAGS(sData)
;
;;    if (nFields lt 2) then $
;;        return, 0
;if (nFields lt 1) then $
;  return, 0
;
;fieldNames = TAG_NAMES(sData)
;
;n = N_ELEMENTS(sData.(0))
;
;;; Make sure all fields are vectors of the same length.
;for i=0,nFields-1 do begin
;    if (SIZE(sData.(i), /N_DIMENSIONS) ne 1) then $
;      return, 0
;    if (n ne N_ELEMENTS(sData.(i))) then $
;      return, 0
;endfor
;
;;; We made it successfully thru all fields.
;;; Now check for "time series" data, where the first column is
;;; monotonically increasing (or decreasing) and evenly-spaced.
;;    x = sData.(0)
;;    dx = x[1:*] - x[0:n-2]
;;    meanDx = TOTAL(dx)/(n-1)
;    
;;; Is the first column evenly spaced?
;;;    if (meanDx && (ABS((MAX(dx) - MIN(dx))/meanDx) lt 0.2)) then begin
;;; Create a separate data container for each column, using
;;; the first column as the indepentent X "time" data and
;;; the other columns as the dependent Y data.
;; iTools does not handle '_[0-9]' characters in filenames well
;; replace all '_' with '-'
;while ((pos = stregex(name,'_[0-9]')) ne -1) do begin
;    strput, name,'-',pos
;endwhile
;
;oData = OBJ_NEW('IDLitParameterSet' $
;                ,NAME=name $
;                ,identifier='id'+name $
;                ,ICON='plot' $
;                ,type='ASCIICOL' $
;                ,DESCRIPTION=description)
;oData->AddMetaData,'DatasetName',name ; give it same name as the file basename
;
;for i=0,nFields-1 do begin
;    axisType = (i eq 0)? i : i+1
;    if (nFields eq 1) then axisType = 2 ; ie single column should be dependent axis
;;          if (i eq 0) then axisType=0
;;          if ((i eq 1) || (i gt 2)) then axisType=2
;;          if (i eq 2) then axisType=3
;    oItem = OBJ_NEW('IDLitDataDAVE', sData.(i),axisType=axisType,type=partype(sData.(i)), $
;                    NAME=fieldNames[i],description=fieldNames[i])
;    oItem->AddMetaData,'Long_name',fieldNames[i]
;    oItem->AddMetaData,'Distribution','POINT'
;    
;    oData->Add, oItem, parameter_name=strtrim(axisType,2)
;    
;          ;; metadata
;endfor
;return, 1
;;    endif
;
;; Failure
;;    return, 0
;end


;===============================================================================
pro DAVEreadAscii_event, event
  compile_opt idl2
  
  uname = widget_info(event.id,/uname)
  widget_control, event.top, get_uvalue=sPtr

  list = ['XN','YN','DN','XT','YT','DT','XU','YU','DU']

  case uname of
     'OK': begin
        for i=0,n_elements(list)-1 do begin
           id = widget_info(event.top,find_by_uname=list[i])
           widget_control, id, get_value=lab
           (*sPtr).label[i] = lab
        endfor
        
        (*sPtr).ok = 1
        
        widget_control, event.top, /destroy
     end

     'CANCEL': begin
        (*sPtr).ok = 0
        widget_control, event.top, /destroy
     end

     else: begin
        (*sPtr).ok = 0
        widget_control, event.top, /destroy
     end
  endcase 
end


;===============================================================================
function DAVEreadAscii::SetLabels, label
  compile_opt idl2

  oTool = self->GetTool()
  if (not OBJ_VALID(oTool)) then $
     return, 0

  oUI = oTool->GetUI()

  ; Prompt user to set data axes labels
  self->SetProperty, label=label
  success = oTool->DoUIService('SetDataAxesLabels', self)
  if (success) then self->GetProperty, label=label

  return, success

end


;===============================================================================
function DAVEreadAscii::isAsciiSpe, filename
  compile_opt idl2

  catch, iErr
  if (iErr ne 0) then begin
     catch, /cancel
     
     goto, IOERROR
  endif

  openr, lun, filename, /get_lun
  finfo = FSTAT(lun)
  
  if (finfo.size eq 0) then goto, IOERROR

  ;; First test: first line should contain 2 nos only.
  line = ''
  readf, lun, line
  toks = strtrim(strsplit(line,' ',/extract,count=ntoks),2)
  if (ntoks ne 2) then goto, IOERROR

  ;; Second test: second line should begin with a #
  line = ''
  readf, lun, line
  if (strmid(line,0,1) ne '#') then  goto, IOERROR

  ;; Last test: a data vector should be readable
  len = fix(toks[0])
  if (len le 0) then goto, IOERROR
  line = fltarr(len)
  readf, lun, line

  free_lun, lun, /force
  
  return, 1

IOERROR:

  if (n_elements(lun) gt 0) then begin
     sStat = fStat(lun)
     if (sStat.open ne 0) then free_lun, lun, /force
  endif
  
  return, 0

end


;===============================================================================
function DAVEreadAscii::isAsciiGrp, filename
  compile_opt idl2
  
  catch, iErr
  if (iErr ne 0) then begin
     catch, /cancel
     
     goto, IOERROR
  endif
  
  openr, lun, filename, /get_lun
  finfo = FSTAT(lun)
  
  if (finfo.size eq 0) then  goto, IOERROR  

  ;; First test: first line after comments should contain size of
  ;; first independent axis.
  repeat begin
     line = ''
     readf, lun, line
  endrep  until (strmid(line,0,1) ne '#') 
  n1 = strtrim(strsplit(line,' ',/extract,count=ntoks),2)
  if (ntoks ne 1) then goto, IOERROR
  n1 = fix(n1[0])

  ;; Second test: next two lines should be a comment followed by size of
  ;; second independent axis. 
  line = ''
  readf, lun, line
  if (strmid(line,0,1) ne '#') then goto, IOERROR

  line = ''
  readf, lun, line
  n2 = strtrim(strsplit(line,' ',/extract,count=ntoks),2)
  if (ntoks ne 1) then goto, IOERROR
  n2 = fix(n2[0])

  ;; Last test: get the vector of first independent values
  line = ''
  readf, lun, line
  if (strmid(line,0,1) ne '#') then goto, IOERROR
  
  line = fltarr(n1)
  readf, lun, line

  free_lun, lun, /force
  
  return, 1

IOERROR:

  if (n_elements(lun) gt 0) then begin
     sStat = fStat(lun)
     if (sStat.open ne 0) then free_lun, lun, /force
  endif
  
  return, 0
  
end


;;===============================================================================
;function DAVEreadAscii::ReadAsciiSpe, filename, oData
;compile_opt idl2
;
;catch, iErr
;if (iErr ne 0) then begin
;    catch, /cancel
;    
;;    if (n_elements(lun) gt 0) then begin
;;        sStat = fStat(lun)
;;        if (sStat.open ne 0) then free_lun, lun, /force
;;    endif
;    
;    return, 0
;endif
;
;label = strarr(9)
;
;;; Read the SPE file
;;; Need to swap x, y axes and transpose the data to be consistent with SPE format
;;; as generated by ISIS
;dm_load_spe,filename,zdat=dat,zerr=err,xdat=y,ydat=x,xtit=ytit,ytit=xtit,ztit=ztit,$
;    error=error,xhist=yhist,yhist=xhist;,group_leader=group_leader
;dat = temporary(transpose(dat))
;err = temporary(transpose(err))
;
;xMode = (xhist eq 0)? 'POINT' : 'HISTOGRAM' 
;yMode = (yhist eq 0)? 'POINT' : 'HISTOGRAM'
;
;label[[0,1,2]] = [xtit,ytit,ztit]
;label[[3,4,5]] = [xtit,ytit,ztit]
;
;isSet = self->SetLabels(label)
;
;xName = (strtrim(label[0]) eq '')? 'X' : label[0]
;yName = (strtrim(label[1]) eq '')? 'Y' : label[1]
;datName = (strtrim(label[2]) eq '')? 'Intensity' : label[2]
;errName = 'Error'
;
;xDesc = (strtrim(label[3]) eq '')? label[0] : label[3]
;yDesc = (strtrim(label[4]) eq '')? label[1] : label[4]
;zDesc = (strtrim(label[5]) eq '')? label[2] : label[5]
;
;xAxisType=0
;yAxisType=1
;datAxisType=2
;errAxisType=3
;
;i = strpos(filename,'.',/reverse_search)
;ext = (i lt 0)? '' : strmid(filename,i)
;basename = file_basename(filename, ext)
;; iTools does not handle '_[0-9]' characters in filenames well
;; replace all '_' with '-'
;while ((pos = stregex(basename,'_[0-9]')) ne -1) do begin
;    strput, basename,'-',pos
;endwhile
;
;oData = OBJ_NEW('IDLitParameterSet' $
;                ,name=basename $
;                ,identifier='id'+basename $
;                ,icon='surface' $
;                ,type='ASCIISPE' $
;                ,description=filename)
;oData->AddMetaData,'DatasetName',basename ; give it same name as the file basename
;
;oX = obj_new('IDLitDataDAVE', x, name=xName,type=partype(x), description=xDesc, axisType=xAxisType)
;oY = obj_new('IDLitDataDAVE', y, name=yName,type=partype(y), description=yDesc, axisType=yAxisType)
;oDat = obj_new('IDLitDataDAVE',dat,name=datName,type=partype(dat), description=zDesc, axisType=datAxisType)
;oErr = obj_new('IDLitDataDAVE',err,name=errName,type=partype(err), description=errName, axisType=errAxisType)
;
;;; metadata
;oX->AddMetaData,'Long_name',xDesc
;if (strtrim(label[6]) ne '') then $
;  oX->AddMetaData,'Units',label[6]
;oX->AddMetaData,'Distribution',xMode
;
;oY->AddMetaData,'Long_name',yDesc
;if (strtrim(label[7]) ne '') then $
;  oY->AddMetaData,'Units',label[7]
;oY->AddMetaData,'Distribution',yMode
;
;oDat->AddMetaData,'Signal',1
;oDat->AddMetaData,'Axes',[xName,yName]
;oDat->AddMetaData,'Long_name',zDesc
;if (strtrim(label[8]) ne '') then $
;  oDat->AddMetaData,'Units',label[8]
;
;oData->Add, [oX,oY,oDat,oErr] $
;            ,parameter_name=strtrim(string([xAxisType,yAxisType,datAxisType,errAxisType]),2)
;
;return, 1
;end



;;===============================================================================
;function DAVEreadAscii::ReadAsciiGrp, filename, oData
;compile_opt idl2
;
;catch, iErr
;if (iErr ne 0) then begin
;    catch, /cancel
;    
;    if (n_elements(lun) gt 0) then begin
;        sStat = fStat(lun)
;        if (sStat.open ne 0) then free_lun, lun, /force
;    endif
;    
;    return, 0
;endif
;
;openr, lun, filename, /get_lun  ; open file
;
;label = strarr(9)
;;; first line after comments should contain size of
;;; first independent axis.
;repeat begin
;    line = ''
;    readf, lun, line
;endrep  until (strmid(line,0,1) ne '#') 
;n1 = strtrim(strsplit(line,' ',/extract,count=ntoks),2)
;if (ntoks ne 1) then return, 0
;n1 = fix(n1[0])
;
;;; Same again for size of 2nd independent axis.
;repeat begin
;    line = ''
;    readf, lun, line
;endrep  until (strmid(line,0,1) ne '#') 
;n2 = strtrim(strsplit(line,' ',/extract,count=ntoks),2)
;if (ntoks ne 1) then return, 0
;n2 = fix(n2[0])
;
;;; First independent axis
;line = ''
;readf, lun, line
;if (strmid(line,0,1) ne '#') then return, 0
;x = fltarr(n1)
;readf, lun, x
;label[3] = strtrim(strmid(line,1),2)
;label[0] = label[3]
;
;;; Second independent axis
;line = ''
;readf, lun, line
;if (strmid(line,0,1) ne '#') then return, 0
;y = fltarr(n2)
;readf, lun, y
;label[4] = strtrim(strmid(line,1),2)
;label[1] = label[4]
;
;;; The data
;data = fltarr(n1,n2)
;err = fltarr(n1,n2)
;buf = fltarr(2*n1)
;index1 = indgen(n1)*2
;index2 = indgen(n1)*2+1
;for i=0,n2-1 do begin
;    readf, lun, line
;    readf, lun, buf
;    data[*,i] = buf[index1]
;    err[*,i] = buf[index2]
;endfor
;label[2] = 'Intensity'
;label[5] = 'Counts'
;
;free_lun, lun, /force           ; close file
;
;isSet = self->SetLabels(label)
;
;xName = (strtrim(label[0]) eq '')? 'X' : label[0]
;yName = (strtrim(label[1]) eq '')? 'Y' : label[1]
;datName = (strtrim(label[2]) eq '')? 'Z' : label[2]
;errName = 'Error'
;
;xDesc = (strtrim(label[3]) eq '')? label[0] : label[3]
;yDesc = (strtrim(label[4]) eq '')? label[1] : label[4]
;zDesc = (strtrim(label[5]) eq '')? label[2] : label[5]
;
;xAxisType=0
;yAxisType=1
;datAxisType=2
;errAxisType=3
;
;i = strpos(filename,'.',/reverse_search)
;ext = (i lt 0)? '' : strmid(filename,i)
;basename = file_basename(filename, ext)
;
;; iTools does not handle '_[0-9]' characters in filenames well
;; replace all '_' with '-'
;while ((pos = stregex(basename,'_[0-9]')) ne -1) do begin
;    strput, basename,'-',pos
;endwhile
;
;oData = OBJ_NEW('IDLitParameterSet' $
;                ,name=basename $
;                ,identifier='id'+basename $
;                ,icon='surface' $
;                ,type='ASCIIGRP' $
;                ,description=filename)
;oData->AddMetaData,'DatasetName',basename ; give it same name as the file basename
;
;oX = obj_new('IDLitDataDAVE', x, name=xName,type=partype(x), description=xDesc, axisType=xAxisType)
;oY = obj_new('IDLitDataDAVE', y, name=yName,type=partype(y), description=yDesc, axisType=yaxisType)
;oDat = obj_new('IDLitDataDAVE',data,name=datName,type=partype(data), description=zDesc,axisType=datAxisType)
;oErr = obj_new('IDLitDataDAVE',err,name=errName,type=partype(err), description=errName,axisType=errAxisType)
;
;;; metadata
;oX->AddMetaData,'Long_name',xDesc
;if (strtrim(label[6]) ne '') then $
;  oX->AddMetaData,'Units',label[6]
;oX->AddMetaData,'Distribution','POINT' ; grp format can't hold histogram data
;
;oY->AddMetaData,'Long_name',yDesc
;if (strtrim(label[7]) ne '') then $
;  oY->AddMetaData,'Units',label[7]
;oY->AddMetaData,'Distribution','POINT' ; grp format can't hold histogram data
;
;oDat->AddMetaData,'Signal',1
;oDat->AddMetaData,'Axes',[xName,yName]
;oDat->AddMetaData,'Long_name',zDesc
;if (strtrim(label[8]) ne '') then $
;  oDat->AddMetaData,'Units',label[8]
;
;;  oX->GetProperty, validAxisTypes=vaTypes
;;  vaTypes = ['X','Y','DATA','ERROR']
;;  xpName = vaTypes[xAxisType]
;;  ypName = vaTypes[yAxisType]
;;  datpName = vaTypes[datAxisType]
;;  errpName = vaTypes[errAxisType]
;;  oData->Add, [oX,oY,oDat,oErr], parameter_name=[xpName,ypName,datpName,errpName]
;oData->Add, [oX,oY,oDat,oErr] $
;            ,parameter_name=strtrim(string([xAxisType,yAxisType,datAxisType,errAxisType]),2)
;
;return, 1
;end


;===============================================================================
; DAVEReadAscii::GetData
;
; Purpose:
; Internal procedure for obtaining the properties of an image file.
;
; Parameters:
; None.
;
; Returns 1 for success, 0 for error, -1 for cancel.
;
function DAVEreadAscii::GetData, oData
compile_opt idl2, hidden

catch, iErr
if(iErr ne 0)then begin
    catch, /cancel
    goto, ioerr                 ; do any cleanup needed
endif
on_ioerror, ioerr

oTool = self->GetTool()
if (not OBJ_VALID(oTool)) then $
  return, 0

;; Get file to be read
strFilename = self->GetFilename()


;; Is this an ASCII file? No need to proceed if it is not.
if (~QUERY_ASCII(strFilename)) then return, 0

                                ;filename = file_basename(strFilename)

;; Is file in SPE format
isSpe = self->IsAsciiSpe(strFilename)
if (isSpe) then begin
   oData = obj_new('ASCIISPEDataset',filename=strFilename)
   if (~obj_valid(oData)) then return, 0

   oData->GetProperty,axis1Label=xtit, axis2Label=ytit, dataLabel=ztit,axis1Name=xName,axis2Name=yName $
                     ,dataName=zName,axis1Units=xUnits, axis2Units=yUnits, dataUnits=zUnits
   label = [xName,yName,zName,xtit,ytit,ztit,xUnits,yUnits,zUnits]
   
   if (self->SetLabels(label)) then begin
      oData->SetProperty,axis1Name=label[0], axis2Name=label[1], dataName=label[2] $
                        ,axis1Label=label[3], axis2Label=label[4], dataLabel=label[5] $
                        ,axis1Units=label[6], axis2Units=label[7], dataUnits=label[8]
   endif

   return, obj_valid(oData)
endif

;; is file in group ASCII format
isGrp = self->IsAsciiGrp(strFilename)
if (isGrp) then begin
   oData = obj_new('ASCIIGrpDataset',filename=strFilename)
   if (~obj_valid(oData)) then return, 0

   oData->GetProperty,axis1Label=xtit, axis2Label=ytit, dataLabel=ztit,axis1Name=xName,axis2Name=yName $
                     ,dataName=zName,axis1Units=xUnits, axis2Units=yUnits, dataUnits=zUnits
   label = [xName,yName,zName,xtit,ytit,ztit,xUnits,yUnits,zUnits]
   
   if (self->SetLabels(label)) then begin
      oData->SetProperty,axis1Name=label[0], axis2Name=label[1], dataName=label[2] $
                        ,axis1Label=label[3], axis2Label=label[4], dataLabel=label[5] $
                        ,axis1Units=label[6], axis2Units=label[7], dataUnits=label[8]
   endif

   return, obj_valid(oData)
endif

;; Initialize if necessary.
if (~PTR_VALID(self._pTemplate)) then $
  self._pTemplate = PTR_NEW(/ALLOC) $
else $
  *self._pTemplate = 0


;; First determine what type of ASCII format is stored in file


success = oTool->DoUIService('AsciiTemplate', self)

;; See if user hit "Cancel" on the dialog.
if (~success || ~N_TAGS(*self._pTemplate)) then $
  return, -1



sData = READ_ASCII(strFilename, $
                   COUNT=nrecords, $
                   HEADER=header, $
                   TEMPLATE=*self._pTemplate)

;; Should we throw an error if there are no records?
nFields = N_TAGS(sData)
if ((nrecords eq 0) or (nFields eq 0)) then $
  return, 0

;;  name = FILE_BASENAME(strFilename, '.txt', /FOLD_CASE)
;i = strpos(strFilename,'.',/reverse_search)
;ext = (i lt 0)? '' : strmid(strFilename,i)
;name = file_basename(strFilename, ext)
;
;;; Attempt to use the header as the data description.
;if (N_ELEMENTS(header) gt 0) then begin
;    lengths = STRLEN(header)
;    good = WHERE(lengths gt 0, ngood)
;    ;; Just use the first non-blank line as the description.
;    if (ngood gt 0) then $
;      description = header[good[0]]
;endif
;
;
;if (self->_HandleVectorData(sData, name, description, oData)) then $
;  return, 1

; Extract sData contents into an array plus column titles

fieldNames = TAG_NAMES(sData)

n = N_ELEMENTS(sData.(0))
data = dblarr(nFields,n)

;; Make sure all fields are vectors of the same length.
for i=0,nFields-1 do begin
   coldata = sData.(i)
    if (SIZE(coldata, /N_DIMENSIONS) ne 1) then return, 0  ; must be a vector
    if (n ne N_ELEMENTS(colData)) then return, 0           ; all must have same length
    data[i,*] = coldata
endfor

oData = obj_new('ASCIIColumnDataset',filename=strFilename,data=data,header=fieldNames)
if (obj_valid(oData)) then return, 1

;fieldNames = TAG_NAMES(sData)
;
;
;if (nFields gt 1) then begin
;    oData = OBJ_NEW('IDLitParameterSet', NAME=name, $
;                    DESCRIPTION=description, $
;                    TYPE='IDLUNKNOWNDATA')
;    oData->AddMetaData,'DatasetName',name ; give it same name as the filename
;endif
;
;
;for i=0,nFields-1 do begin
;    
;    name1 = name
;    if (nFields gt 1) then $
;      name1 += '.' + fieldNames[i]
;    
;    ;; Copy out the first field and remove dims of length 1.
;    data1 = REFORM(sData.(i))
;    
;    ;; Create the Data object
;    case (SIZE(data1, /N_DIMENSIONS)) of
;        1: oData1 = OBJ_NEW('IDLitDataIDLVector', data1, $
;                            NAME=name1, DESCRIPTION=description)
;        2: oData1 = OBJ_NEW('IDLitDataIDLArray2D', data1, $
;                            NAME=name1, DESCRIPTION=description)
;        3: oData1 = OBJ_NEW('IDLitDataIDLArray3D', data1, $
;                            NAME=name1, DESCRIPTION=description)
;        else: oData1 = OBJ_NEW('IDLitData', data1, type="ARRAY", $
;                               NAME=name1, DESCRIPTION=description)
;    endcase
;    
;    ;; Either add to container, or just copy the data objref.
;    if (nFields gt 1) then $
;        oData->Add, oData1 $
;    else $
;      oData = oData1
;endfor


return, 1

ioerr:                          ; IO Error handler
if(n_elements(unit) gt 0)then begin
    sStat = fStat(unit)
    if(sStat.open ne 0)then $
      free_lun, unit
    
endif
self->SignalError, !error_state.msg, severity=2
return, 0
end


;===============================================================================
; DAVEreadAscii::GetProperty
; 
; PURPOSE:
;   Get method for class
;
; PARAMETERS
;
; KEYWORDS:
;
pro DAVEreadAscii::GetProperty, label=label, _REF_EXTRA=etc
compile_opt idl2

if (arg_present(label)) then begin
    label =  self.label
endif

if(n_elements(etc) gt 0) then $
  self->IDLitReadAscii::GetProperty, _EXTRA=etc

end


;===============================================================================
; DAVEreadAscii::SetProperty
; 
; PURPOSE:
;   Set method for class
;
; PARAMETERS
;
; KEYWORDS:
;
pro DAVEreadAscii::SetProperty, label=label, _EXTRA=etc
compile_opt idl2

if (n_elements(label) gt 0) then begin
   if (n_elements(label) eq n_elements(self.label)) then $
      self.label = label
endif

if(n_elements(etc) gt 0) then $
  self->IDLitReadAscii::SetProperty, _EXTRA=etc 

end


;===============================================================================
; Init
function DAVEreadAscii::Init, _REF_EXTRA=_extra
compile_opt idl2

if (self->IDLitReader::Init(['grp','txt','spe','dat','jqy','ijy']  $
                            ,NAME='ASCII text' $
                            ,DESCRIPTION="ASCII text file" $
                            ,_EXTRA=_extra) eq 0) then $
  return, 0

;; Set the properties.
self->IDLitReadAscii::SetProperty, _EXTRA=_EXTRA

return, 1
end


;===============================================================================
; Class structure definition
pro DAVEreadAscii__Define
compile_opt idl2

void = {DAVEreadAscii, inherits IDLitReadAscii,label:strarr(9)}

end
