; $Id$

;###############################################################################
;
;NAME:
;        strendsub
;
;PURPOSE:
;           Substitute the last n letters of s with ssub and return the new string.
;           This is more generally useful than just for the addheader methods.
;PARAMETERS:
;           s       The string.
;           ssub    The text used to replace the selected substring.
;           n       The length from the end of s of the substring to replace.
;KEYWORDS:
;           none
;
;RETURN VALUE:
;           snew    The new string with the sustituted substring.
;###############################################################################
function strendsub,s,ssub,n
    ;SUBSTITUTE THE LAST n LETTERS OF s WITH ssub

    snew = strarr(n_elements(s))
    lens = strlen(s)

    for i=0,n_elements(s)-1 do begin
        stemp = strmid(s[i],0,lens[i]-n)
        snew[i] =  stemp + ssub
    endfor;i

    return,snew
end;strendsub