; $Id$
;###############################################################################
;+
; NAME:
;   Quadrature
;
; PURPOSE:
;   Combine the two input arguments in quadrature
;
; CATEGORY:
;   DAVE Utilities

; PARAMETERS
;   x - the first input argument. Can be a scaler or a vector. Both x and y must be of the same size
;
;   y - the second input argument. Can be a scaler or a vector. Both x and y must be of the same size
;
; KEYWORDS:
;   identifier (out)   - The string identifier of the DAVETool object
;
; Return Value:
;   returns quadrature sum of the two inputs or -1 if there is an error
;-

function Quadrature, x,y
  compile_opt idl2

  result = -1

  ; Basic error Handler
  if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
      print,'Quadrature: Error Encountered'
      print,!ERROR_STATE.MSG
      catch, /cancel
      return, result
    endif
  endif

  if n_params() ne 2 then return, result

  if (n_elements(x) eq 0 || n_elements(y) eq 0) then return, result

  if (total(size(x) eq size(y)) ne n_elements(size(x))) then return, result

  result = sqrt(x^2 + y^2)

  return, result

end

