; $Id$
;###############################################################################
;
;FILENAME:
;        nse_comboindex.pro
;
;PURPOSE:
;
;CATEGORY:
;
;
;METHODS IN FILE:
;
;METHODS:
;    nse_comboindex
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Wed Feb 09 21:09:35 2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;###############################################################################
;
;NAME:
;        nse_comboindex
;
;PURPOSE:
;       Get the current selected index of a combobox widget.
;PARAMETERS:
;       id  The combobox id.
;KEYWORDS:
;       none
;RETURN VALUE:
;       The current combobox index.
;###############################################################################
function nse_comboindex,id


    if widget_info(id,/valid_id) then begin
        widget_control,id,get_value=val
        txt = widget_info(id,/combobox_gettext)
        return,where(val eq txt)
    endif else begin
        return,-1
    endelse
end;nse_comboindex
