; $Id$
;###############################################################################
;+
; FUNCTION:
;   LocateTreatmentObject
;
; PURPOSE:
;   A very specific utility function that can be used with dataset object classes
;   defined for DAVE. Given any data object in an overall dataset hierarchy, this
;   function can be use to retrieve the treatment object reference from the hierarchy.
;
; CATEGORY:
;   Miscellaneous
;
; PARAMETERS
;   oChild - Any object in the hierarchy from which the treatment object reference 
;            is being sought
;
; KEYWORDS:
;
; RETURN VALUE:
;    If successful, the treatment object reference
;    If unsuccessful, a null object
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; December 2008
;-
;###############################################################################
function LocateTreatmentObject, oItem
void = obj_new()

if (~obj_valid(oItem)) then return, void
oRef=obj_new()
oTop = getmaindataobjectparent(oItem)
if (obj_valid(oTop)) then oTop->GetProperty, trmtRef = oRef

return, oRef

end