;===============================================================================
; locateIndex
;
; PURPOSE:
;   Given a 1D 'array', this function returns the index of the element
;   which is closest to the input 'val'.
;
; PARAMETERS:
;   array [in] - the input array
;
;   val [in] - the value to be located in the array
;
; RETURN VALUE:
;   Index of array value closest to val.
;
function locateIndex, array,val

nspec = size(array,/n_elements)
result = where(array gt val)
if (result[0] lt 0) then begin  ; ie if where function returns null result
    index = nspec-1             ; ==> use last index
endif else begin
    index = result[0]
    diff1 = abs(val - array[index-1]) 
    diff2 = abs(array[index] - val)
    if (diff1 le diff2) then index = index - 1 ; use index of element closer to val!
endelse

return, index

end
;-------------------------------------------------------------------------------


