; $Id$
;###############################################################################
;
; NAME:
;   locate_web_browser
;
; PURPOSE:
;   Locate a dafault web browser on all supported platforms
;   Should work for standard installations of:
;   Linux, Irix, MacOS X and Windows
;
; CATEGORY:
;   DAVE Framework
;
; AUTHOR:
;   Richard Tumanjong Azuah
;   NIST Center for Neutron Research
;   100 Bureau Drive, Gaithersburg, MD 20899
;   United States
;   azuah@nist.gov; (301) 9755604
;   Feb, 2004
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################



;===============================================================================
; locate_web_browser
;
; PURPOSE:
;   Locate a dafault web browser on all supported platforms
;   Should work for standard installations of:
;   Linux, Irix, MacOS X and Windows
;
; PARAMETERS:
;
; RETURN VALUE:
;   The name of the browser executable found
function locate_web_browser
browser = ''
case strupcase(!version.os_family) of
    'UNIX': begin
        case strupcase(!version.os) of
            'DARWIN': begin     ; MacOS X
                browsers = ['/Applications/Safari.app/Contents/MacOS/Safari',$
                            '/Applications/Safari.app/Contents/MacOS/Firefox',$
                            '/Applications/Internet\ Explorer.app/Contents/MacOS/Internet\ Explorer']
                ind = 0
                while ((strlen(strtrim(browser)) eq 0) && (ind lt n_elements(browsers))) do begin
                    found = file_test(browsers[ind]) ; is file present?
                    if (found) then browser = browsers[ind]
                    ind = ind + 1
                endwhile
            end

            else: begin         ; Other unices
                browsers = ['firefox','chrome','chromium','konqueror','opera','galeon','mozilla','netscape']
                ind = 0
                while ((strlen(strtrim(browser)) eq 0) && (ind lt n_elements(browsers))) do begin
                    cmd = 'which '+browsers[ind]
                    spawn, cmd,result ; is browser executable?
                    browser=result[0]
                    ind = ind + 1
                endwhile
            end
        endcase
    end

    'WINDOWS': begin
        browsers = ['C:\Program Files\Mozilla Firefox\firefox.exe', $
                    'C:\Program Files\Internet Explorer\Iexplore.exe']
        ind = 0
        while ((strlen(strtrim(browser)) eq 0) && (ind lt n_elements(browsers))) do begin
            found = file_test(browsers[ind]) ; is file present?
            if (found) then browser = browsers[ind]
            ind = ind + 1
        endwhile
    end

    else:

endcase

return, browser

end
