; $Id$
;###############################################################################
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function launch_help,pdf_file,tlb = tlb

    if n_params() ne 1 then return,0

    dave_defs = *!dave_defaults
    PDFReader = dave_defs.PDFReader

    ; UNIX platforms only - if the PDF reader is not specified in the pointer
    ; then attempt to locate one
    if (strlowcase(!version.os_family) eq "unix") then begin
        readers = ['acroread','okular','xpdf']   ; programs to search for
        ind = 0
        while ((strtrim(PDFReader,2) eq '') && (ind lt 3)) do begin
            cmd = 'which '+readers[ind]
            spawn, cmd,result   ; problems in IDL5.4 if attempt to assign PDFReader to 'spawn'
            PDFReader=result[0] ; result directly - result is an array after first attempt.
            ind = ind + 1
        endwhile
    endif

    ; All platforms - if the PDF reader is not specified in the pointer 
    ; then launch a dialog that asks to set it
    if (strtrim(PDFReader,2) eq '') then begin
        if n_elements(tlb) gt 0 then begin
            PDFReader = dialog_pickfile(dialog_parent = tlb,/read, $
                                       title="Please select your PDF reader")
        endif else begin
            PDFReader = dialog_pickfile(/read, title="Please select your PDF reader")
        endelse
    endif

    ; if the pdfReader was picked then save it in the defaults file
    if (PDFReader ne '' and PDFReader ne ' ') then begin
        dave_defs.PDFReader = PDFReader
        pdd=!dave_defaults
        ptr_free,pdd
        pdd=ptr_new(dave_defs)
        save,filename=!defaults_file,pdd
        defsysv,'!dave_defaults',pdd
    endif else begin
        return,-1
    endelse

    ; One last check!
    ; A previous setting for the pdfreader may no longer be valid. Check
    ; to ensure the pdfreader exists AND is executable
    info = file_info((*!dave_defaults).PDFReader)
    if (info.exists ne 1) then begin
        msg = 'Help files are in PDF format and a PDF Reader is required!'
        msg = [msg,' ','Your PDF reader which is currently set to:']
        msg = [msg, '"'+(*!dave_defaults).PDFReader+'"']
        msg = [msg,'does not exists!']
        msg = [msg,' ','Please use the menu option']
        msg = [msg,'"File => Select pdf reader"']
        msg = [msg,'from the main window to choose a valid pdf reader']
        
        void = dialog_message(dialog_parent=tlb, msg, /error)
        return, -1
    endif
    if (info.execute ne 1) then begin
        msg = 'Help files are in PDF format and a PDF Reader is required!'
        msg = [msg,' ','Your PDF reader which is currently set to:']
        msg = [msg, '"'+(*!dave_defaults).PDFReader+'"']
        msg = [msg,'cannot be executed!']
        msg = [msg,' ','Please use the menu option']
        msg = [msg,'"File => Select pdf reader"']
        msg = [msg,'from the main window to choose a valid pdf reader']
        
        void = dialog_message(dialog_parent=tlb, msg, /error)
        return, -1
    endif

    ; Should have some value for acroread now
    run_command = (*!dave_defaults).PDFReader + " " + pdf_file

    if (strlowcase(!version.os_family) eq "windows") then begin
        spawn, run_command,/noshell,/nowait
        return,0
    endif
    if (strlowcase(!version.os_family) eq "unix") then begin
        spawn, run_command+" &"
        return,0
    endif
    if (strlowcase(!version.os_family) eq "macos") then begin
        spawn, run_command,/nowait
        return,0
    endif


;we got an error so return a -1
    return,-1
end
