; $Id$
;###############################################################################
;+
; NAME:
;   DAVE
;
; PURPOSE:
;   Display a first time message before DAVE starts to inform user about 
;   important messages about the current version of DAVE. User has the 
;   option to not display the message in future.
;
; CATEGORY:
;   DAVE Utilities

; PARAMETERS
;
; KEYWORDS:
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; July 2008
;-
;###############################################################################



;===============================================================================
; NAME:
;   daveInitMessage_event
;
; PURPOSE:
;   Event Handler
;
pro daveInitMessage_event,event

if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        catch, /cancel
        return
    endif
endif

widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
    'NOSHOW': begin
          (*pstate).noshow = widget_info(event.id,/button_set)
       end
    'DISMISS': begin
          widget_control,event.top,/destroy
       end
    else:
endcase
end


;===============================================================================
;+
; NAME:
;   daveInitMessage
;
; PURPOSE:
;   Display a useful message when DAVE is lauched for the first time. User has option to prevent
;   message from being displayed subsequently.
;
; PARAMETERS
;
; KEYWORDS:
;-
function daveInitMessage

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        print,'daveInitMessage: Error Encountered'
        print,!ERROR_STATE.MSG
        catch, /cancel
        if (widget_info(tlb,/valid)) then widget_control, tlb, /destroy
        return, 0
    endif
endif

; Retrieve the app directory
appDir = getDAVEConfigDir()
if (n_elements(appDir) le 0) then return, 0
if (~file_test(appDir,/write,/read)) then return, 0

; Default msgFlag is 1 (== show message)
msgFlag = 1

; Retrieve the msgFlag setting from file, if previously created.
msgFlagFile = appDir+path_sep()+'firstmsgflag.txt'
if (file_test(msgFlagFile,/read)) then begin
    openr, lun, msgFlagFile, /get_lun
    readf, lun, msgFlag
    close, lun, /force
endif

if (msgFlag eq 0) then return, 1

title = 'Important Information'
tlb = widget_base(/col,title = title,/tlb_frame_attr,/base_align_center)
strout = ['The DAVE codebase has recently undergone a significant overhaul', $
    'which has also resulted in changes to the user interface and', $
    'the way in which some program modules are used.', $
    ' ', $
    'If you are a new user or are accustomed to the previous verson of DAVE,', $
    "you may find it useful to begin by checking out the 'Getting Started'", $
    'tutorial that is included in the integrated application help', $
    'To accomplish this, when the application starts up, ', $
    'Click on the following menu', $
;    ' ', $
    "Help => User's Manual", $
;    ' ', $
    "and then select the ", $
    "Getting Started", $
    "chapter for the basic tutorial.", $
    'Afterwards, you are welcomed to check out the rest of the manual', $
    'and to explore the new features in DAVE.', $
    ' ', $
    'If you encounter problems, get in touch with your instrument scientist', $
    'or any member of the DAVE development team']
;this_len = 75
;void = widget_text(tlb,value = strout,ysize = n_elements(strout), $
;   xsize = this_len,align)
n = n_elements(strout)
CB1 = widget_base(tlb,/col,/frame,/base_align_center)
for i=0,n-1 do begin
    fgcolor = (i eq 9 || i eq 11)? [255,0,0] : [0,0,255]
    void = cw_coloredlabel(CB1,/align_center,value=strout[i],foreground_color=fgcolor)
    ;void = widget_label(CB1,/align_center,value=strout[i])
endfor

CB2 = widget_base(tlb,/nonexclusive)
show_id = widget_button(CB2,value = "Do not show me this again", $
   uname = 'NOSHOW')
void = widget_button(tlb,value = 'CONTINUE',uname = 'DISMISS')
centertlb,tlb

widget_control,tlb,/realize

state = {noshow:~msgFlag}
pstate = ptr_new(state)
widget_control,tlb,set_uvalue = pstate
reg_name = '_firstmsg_'
xmanager,reg_name,tlb,event_handler = 'daveInitMessage_event'

msgFlag = 1 - (*pstate).noshow
ptr_free,pstate


; Save msgFlag setting
openw, lun, msgFlagFile, /get_lun
printf, lun, msgFlag
close, lun, /force

return, 1

end

