; $Id$
;
;THIS WAS INTENDED TO PROVIDE A DATA CLASS FOR AN IMAGE DISPLAY TOOL, BUT IT IS NOT CURRENTLY USED IN DAVE.
;
;###############################################################################
;
;NAME:
;        cwo_drawImage_data::xrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawImage_data::xrange

    sz = size(*self.image)

    return,[0,sz[1]]

end;xrange
;###############################################################################
;
;NAME:
;        cwo_drawImage_data::yrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_drawImage_data::yrange

    sz = size(*self.image)

    return,[0,sz[2]]

end;yrange

pro cwo_drawImage_data::getProperty,x=x,y=y,image=image,simage=simage,$
                                    workdir=workdir,showdata=showdata,$
                                    id=id,_Extra=extra
;print,'cwo_drawImage_data::getProperty'

    if arg_present(x) gt 0 then x = *self.x
    if arg_present(y) gt 0 then y = *self.y
    if arg_present(image) gt 0 then image = *self.image
    if arg_present(simage) gt 0 then simage = *self.simage
    if arg_present(workdir) gt 0 then workdir = self.workdir
    if arg_present(showdata) gt 0 then showdata = self.showdata
    if arg_present(id) gt 0 then id = self.id

;print,*self.image

end;cwo_drawImage_data::getProperty
pro cwo_drawImage_data::setProperty,x=x,y=y,image=image,simage=simage,$
                                    workdir=workdir,showdata=showdata,$
                                    id=id,_Extra=extra
;print,'cwo_drawImage_data::setProperty'
    if n_elements(x) ne 0 then *self.x = x
    if n_elements(y) gt 0 then *self.y = y
    if n_elements(image) gt 0 then *self.image = image
    if n_elements(simage) gt 0 then *self.simage = simage
    if n_elements(workdir) gt 0 then self.workdir = workdir
    if n_elements(showdata) gt 0 then self.showdata = showdata
    if n_elements(id) gt 0 then self.id = id

end;cwo_drawImage_data::setProperty
pro cwo_drawImage_data::getImage,image
    image = *self.image
end;cwo_drawImage_data::getImage

pro cwo_drawImage_data::setImage,image

    if ptr_valid(self.image) then ptr_free,self.image
    self.image = ptr_new(image)

end;cwo_drawImage_data::setImage
pro cwo_drawImage_data::cleanup
    print,'cwo_drawImage_data::cleanup'
    if ptr_valid(self.x) ne 0 then ptr_free,self.x
    if ptr_valid(self.y) ne 0 then ptr_free,self.y
    if ptr_valid(self.image) ne 0 then ptr_free,self.image
    if ptr_valid(self.simage) ne 0 then ptr_free,self.simage

end;cwo_drawImage_data::cleanup
function cwo_drawImage_data::init,x=x,y=y,image=image,simage=simage,$
                                    workdir=workdir,showdata=showdata,$
                                    id=id

    if n_elements(x) gt 0 then self.x = ptr_new(x)
    if n_elements(y) gt 0 then self.y = ptr_new(y)
    if n_elements(image) gt 0 then self.image = ptr_new(image)
    if n_elements(simage) gt 0 then self.simage = ptr_new(simage)
    if n_elements(workdir) gt 0 then self.workdir = workdir
    if n_elements(showdata) gt 0 then self.showdata = showdata
    if n_elements(id) gt 0 then self.id = id

    return,1

end;cwo_drawImage_data::init
pro cwo_drawImage_data__define,class

    class =   { cwo_drawImage_data,$
                    x:ptr_new(),$
                    y:ptr_new(),$
                    image:ptr_new(),$
                    simage:ptr_new(),$
                    workdir:'',$
                    legend:'',$
                    color:0L,$
                    psym:0,$
                    linestyle:0,$
                    thesymsize:1.0,$
                    showdata:0,$
                    showlegend:0,$
                    ebshow:0,$
                    black:0L,$              ;COLORS
                    red:255L,$
                    green:256L*255L,$
                    blue:256L*256L*255L,$
                    white:255L + 256L*(255L + 256L*255L),$
                    ID:''}

end;cwo_drawImage_data__define

