;===============================================================================
; IDLitDataDave::getProperty
; 
; PURPOSE:
;   Accessor
;
pro IDLitDataDave::GetProperty, axisType=axisType, extraType=extraType, validAxisTypes=vat, _REF_EXTRA=etc
compile_opt idl2

if (arg_present(axisType)) then axisType = self.axisType

if (arg_present(extraType)) then extraType = self.extraType

if (arg_present(vat)) then vat=self.validAxisTypes

;; Call base class accessor
if(n_elements(etc) gt 0) then $
  self->IDLitData::GetProperty, _EXTRA=etc 

end


;===============================================================================
; IDLitDataDave::setProperty
; 
; PURPOSE:
;   Mutator
;
pro IDLitDataDave::SetProperty, axisType=axisType, extraType=extraType, _EXTRA=etc
compile_opt idl2

if (n_elements(axisType)) then begin
    self.axisType = axisType
    if (axisType lt 0) then self.axisType = 0
    if (axisType gt 4) then self.axisType = 4
endif

if (n_elements(extraType)) then begin
    self.extraType = strtrim(string(extraType),2)
endif

;; Call base class mutator
if(n_elements(etc) gt 0) then $
  self->IDLitData::SetProperty, _EXTRA=etc 

end


;===============================================================================
; IDLitDataDave::Init
; 
; PURPOSE:
;   Initialize an object of this class
;
; PARAMETERS:
;
; KEYWORDS:
;
; RETURN VALUE:
;    1 - if successful
;    0 - otherwise
;
function IDLitDataDAVE::Init, data,axisType=axisType, extraType=extraType, _EXTRA=etc
compile_opt idl2

;; call superclass init
if (~self->IDLitData::Init(data, _EXTRA=etc)) then return, 0

self.axisType = 4   ; 'UNDEFINED' by default
if (n_elements(axisType) gt 0) then $
  self->SetProperty, axisType=axisType

if (n_elements(extraType) gt 0) then $
  self->SetProperty, extraType=extraType

self.validAxisTypes = ['X','Y','DATA','ERROR','UNDEFINED']
self->RegisterProperty, 'axisType', enumlist=self.validAxisTypes, description='Axis Type' $
  ,name='Axis Type',sensitive=1
  
;self->RegisterProperty, 'extraType', /string, description='Extra Type' $
;  ,name='Extra Type',sensitive=0


return, 1

end


;===============================================================================
; IDLitDataDave__define
; 
; PURPOSE:
;   class structure definition
;
pro IDLitDataDAVE__define
compile_opt idl2

struct = {IDLitDataDAVE, $
          inherits IDLitData $
          ,extraType:'' $       ; used when required for specifying additional data types
          ,axisType:0B $        ; 0->3 corresponding to values in validAxisTypes vector
          ,validAxisTypes:['X','Y','DATA','ERROR','UNDEFINED'] $ ; valid axis types
         }

end

