;+
; mare_rebinnd will make a shared library out of rebinnd.c in input_dir
; and put in into output_dir (by default same directory as dave.sav)
; The shared library name is rebinnd_linux_64.so for 64 bit linux, 
; rebinnd_linux_32.so for 32 bit linux, ...
; 
; Date: 03/11/2010
; To do: 3d rebinning
; 
; Author: Andrei Savici saviciat@ornl.gov
;-
pro make_rebinnd,input_dir=input_dir,output_dir=output_dir
  if (N_elements(input_dir) ne 1) then input_dir="/SNS/users/3y9/C-test/"
  source="rebinnd"
  export_rtns=["rebin1d_nat_yew","rebin1d_yew","rebin1d_nat_ye","rebin1d_ye",$
    "rebin1d_nat_yw","rebin1d_yw","rebin1d_nat_y","rebin1d_y", $
    "rebin2d_nat_zew","rebin2d_zew","rebin2d_nat_ze","rebin2d_ze",$
    "rebin2d_nat_zw","rebin2d_zw","rebin2d_nat_z","rebin2d_z", $
    "rebin3d_nat_iew","rebin3d_iew","rebin3d_nat_ie","rebin3d_ie",$
    "rebin3d_nat_iw","rebin3d_iw","rebin3d_nat_i","rebin3d_i"]
  if (N_elements(output_dir) ne 1) then output_dir=file_dirname(ROUTINE_FILEPATH('dave'),/MARK_DIRECTORY)
  if strlen(output_dir) le 3 then output_dir=input_dir
  filename='rebinnd'+'_'+!version.os+'_'+strtrim(string(!VERSION.MEMORY_BITS),2)
  MAKE_DLL,source,filename, export_rtns, $
    INPUT_DIR=input_dir, DLL_PATH=shlib, output_dir=output_dir,$
    EXTRA_CFLAGS='-O2';,/nocleanup ,/verbose
  ;print,shlib
end
