/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import com.microstar.xml.XmlException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotApplication;
import ptolemy.plot.PlotBox;
import ptolemy.plot.plotml.PlotBoxMLParser;
import ptolemy.plot.plotml.PlotMLApplication;
import ptolemy.plot.plotml.PlotMLParser;

public class PlotMLApplication
extends PlotApplication {
    public PlotMLApplication() throws Exception {
        this((String[])null);
    }

    public PlotMLApplication(String[] args) throws Exception {
        this(new Plot(), args);
    }

    public PlotMLApplication(PlotBox plot, String[] args) throws Exception {
        super(plot, args);
    }

    public static void main(String[] args) {
        try {
            1 doActions = new /* Unavailable Anonymous Inner Class!! */;
            SwingUtilities.invokeAndWait((Runnable)doActions);
        }
        catch (Exception ex) {
            System.err.println(ex.toString());
            ex.printStackTrace();
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    @Override
    protected void _about() {
        JOptionPane.showMessageDialog(this, "PlotMLApplication class\nBy: Edward A. Lee and Christopher Hylands\nVersion 5.7, Build: $Id: PlotMLApplication.java,v 1.38 2006/09/21 15:39:59 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-2006, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    @Override
    protected void _help() {
        JOptionPane.showMessageDialog(this, "PlotMLApplication is a standalone plot  application.\n  File formats understood: PlotML and Ptplot ASCII.\n  Left mouse button: Zooming.\n\n" + this._usage(), "About Ptolemy Plot", 1);
    }

    @Override
    protected void _read(URL base, InputStream in) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(in);
        bin.mark(9);
        byte[] peek = new byte[8];
        int bytesRead = bin.read(peek);
        if (bytesRead != peek.length) {
            throw new IOException("Read only " + bytesRead + "bytes, expecting " + peek.length);
        }
        bin.reset();
        if (new String(peek).startsWith("<?xm")) {
            PlotBoxMLParser parser = this._newParser();
            try {
                parser.parse(base, bin);
            }
            catch (Exception ex) {
                String msg;
                if (ex instanceof XmlException) {
                    XmlException xmlex = (XmlException)ex;
                    msg = "PlotMLApplication: failed to parse PlotML data:\nline: " + xmlex.getLine() + ", column: " + xmlex.getColumn() + "\nIn entity: " + xmlex.getSystemId() + "\n";
                } else {
                    msg = "PlotMLApplication: failed to parse PlotML data:\n";
                }
                System.err.println(String.valueOf(msg) + ex.toString());
                ex.printStackTrace();
            }
        } else {
            super._read(base, bin);
        }
    }

    protected PlotBoxMLParser _newParser() {
        if (this.plot instanceof Plot) {
            return new PlotMLParser((Plot)this.plot);
        }
        return new PlotBoxMLParser(this.plot);
    }
}

