/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColumnControlButton
extends JButton {
    protected JPopupMenu popupMenu = null;
    private JXTable table;
    public static final String COLUMN_CONTROL_MARKER = "column.";
    private List<ColumnVisibilityAction> columnVisibilityActions;
    private PropertyChangeListener columnModelChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("columnModel".equals(propertyChangeEvent.getPropertyName())) {
                ColumnControlButton.this.updateFromColumnModelChange((TableColumnModel)propertyChangeEvent.getOldValue());
            } else if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                ColumnControlButton.this.updateFromTableEnabledChanged();
            }
        }
    };
    private TableColumnModelListener columnModelListener = new TableColumnModelListener(){

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            if (!this.isVisibilityChange(tableColumnModelEvent, true)) {
                ColumnControlButton.this.populatePopupMenu();
            }
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            if (!this.isVisibilityChange(tableColumnModelEvent, false)) {
                ColumnControlButton.this.populatePopupMenu();
            }
        }

        private boolean isVisibilityChange(TableColumnModelEvent tableColumnModelEvent, boolean bl) {
            if (!(tableColumnModelEvent.getSource() instanceof DefaultTableColumnModelExt)) {
                return false;
            }
            DefaultTableColumnModelExt defaultTableColumnModelExt = (DefaultTableColumnModelExt)tableColumnModelEvent.getSource();
            if (bl) {
                return defaultTableColumnModelExt.isAddedFromInvisibleEvent(tableColumnModelEvent.getToIndex());
            }
            return defaultTableColumnModelExt.isRemovedToInvisibleEvent(tableColumnModelEvent.getFromIndex());
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    };

    public ColumnControlButton(JXTable jXTable, Icon icon) {
        this.init();
        this.setAction(this.createControlAction(icon));
        this.installTable(jXTable);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setMargin(new Insets(1, 2, 2, 1));
        if (this.popupMenu != null) {
            this.popupMenu.updateUI();
        }
    }

    public void togglePopup() {
        if (this.popupMenu.isVisible()) {
            this.popupMenu.setVisible(false);
        } else if (this.popupMenu.getComponentCount() > 0) {
            Dimension dimension = this.getSize();
            this.popupMenu.show(this, dimension.width - this.popupMenu.getPreferredSize().width, dimension.height);
        }
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation componentOrientation) {
        super.applyComponentOrientation(componentOrientation);
        this.popupMenu.applyComponentOrientation(componentOrientation);
    }

    private void updateFromColumnModelChange(TableColumnModel tableColumnModel) {
        if (tableColumnModel != null) {
            tableColumnModel.removeColumnModelListener(this.columnModelListener);
        }
        this.populatePopupMenu();
        if (this.canControl()) {
            this.table.getColumnModel().addColumnModelListener(this.columnModelListener);
        }
    }

    protected void updateFromTableEnabledChanged() {
        this.getAction().setEnabled(this.table.isEnabled());
    }

    private boolean canControl() {
        return this.table.getColumnModel() instanceof TableColumnModelExt;
    }

    protected void populatePopupMenu() {
        this.clearPopupMenu();
        if (this.canControl()) {
            this.addColumnMenuItems();
        }
        this.addColumnActions();
    }

    private void clearPopupMenu() {
        this.clearColumnVisibilityActions();
        this.popupMenu.removeAll();
    }

    private void clearColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            return;
        }
        Iterator<ColumnVisibilityAction> iterator = this.columnVisibilityActions.iterator();
        while (iterator.hasNext()) {
            iterator.next().releaseColumn();
        }
        this.columnVisibilityActions.clear();
    }

    private void addColumnMenuItems() {
        List list = this.table.getColumns(true);
        ActionContainerFactory actionContainerFactory = new ActionContainerFactory(null);
        for (TableColumn tableColumn : list) {
            ColumnVisibilityAction columnVisibilityAction = new ColumnVisibilityAction(tableColumn);
            this.getColumnVisibilityActions().add(columnVisibilityAction);
            this.popupMenu.add(actionContainerFactory.createMenuItem(columnVisibilityAction));
        }
    }

    private List<ColumnVisibilityAction> getColumnVisibilityActions() {
        if (this.columnVisibilityActions == null) {
            this.columnVisibilityActions = new ArrayList<ColumnVisibilityAction>();
        }
        return this.columnVisibilityActions;
    }

    private void addColumnActions() {
        Object[] objectArray = this.getColumnControlActionKeys();
        Arrays.sort(objectArray);
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.isColumnControlActionKey(objectArray[i])) continue;
            arrayList.add(this.table.getActionMap().get(objectArray[i]));
        }
        if (arrayList.size() == 0) {
            return;
        }
        if (this.canControl()) {
            this.popupMenu.addSeparator();
        }
        ActionContainerFactory actionContainerFactory = new ActionContainerFactory(null);
        for (Action action : arrayList) {
            this.popupMenu.add(actionContainerFactory.createMenuItem(action));
        }
    }

    private Object[] getColumnControlActionKeys() {
        Object[] objectArray = this.table.getActionMap().allKeys();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!this.isColumnControlActionKey(objectArray[i])) continue;
            arrayList.add(objectArray[i]);
        }
        return arrayList.toArray();
    }

    private boolean isColumnControlActionKey(Object object) {
        return object instanceof String && ((String)object).startsWith(COLUMN_CONTROL_MARKER);
    }

    private void installTable(JXTable jXTable) {
        this.table = jXTable;
        jXTable.addPropertyChangeListener(this.columnModelChangeListener);
        this.updateFromColumnModelChange(null);
        this.updateFromTableEnabledChanged();
    }

    private void init() {
        this.setFocusPainted(false);
        this.setFocusable(false);
        this.popupMenu = new JPopupMenu();
        JComboBox jComboBox = new JComboBox();
        Object object = jComboBox.getClientProperty("doNotCancelPopup");
        this.putClientProperty("doNotCancelPopup", object);
    }

    private Action createControlAction(Icon icon) {
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColumnControlButton.this.togglePopup();
            }
        };
        abstractAction.putValue("SmallIcon", icon);
        return abstractAction;
    }

    public class ColumnVisibilityAction
    extends AbstractActionExt {
        private TableColumn column;
        private PropertyChangeListener columnListener;

        public ColumnVisibilityAction(TableColumn tableColumn) {
            super((String)null);
            this.setStateAction();
            this.installColumn(tableColumn);
        }

        public void releaseColumn() {
            this.column.removePropertyChangeListener(this.columnListener);
            this.column = null;
        }

        public boolean isEnabled() {
            return super.isEnabled() && this.canControl();
        }

        private boolean canControl() {
            return this.column instanceof TableColumnExt;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (this.canControl()) {
                if (itemEvent.getStateChange() == 2 && ColumnControlButton.this.table.getColumnCount() <= 1) {
                    this.reselect();
                } else {
                    ((TableColumnExt)this.column).setVisible(itemEvent.getStateChange() == 1);
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        private void updateSelected() {
            boolean bl = true;
            if (this.canControl()) {
                bl = ((TableColumnExt)this.column).isVisible();
            }
            this.setSelected(bl);
        }

        private void reselect() {
            this.firePropertyChange("selected", null, Boolean.TRUE);
        }

        private void installColumn(TableColumn tableColumn) {
            this.column = tableColumn;
            tableColumn.addPropertyChangeListener(this.getColumnListener());
            this.setName(String.valueOf(tableColumn.getHeaderValue()));
            this.setActionCommand(tableColumn.getIdentifier());
            this.updateSelected();
        }

        private PropertyChangeListener getColumnListener() {
            if (this.columnListener == null) {
                this.columnListener = this.createPropertyChangeListener();
            }
            return this.columnListener;
        }

        private PropertyChangeListener createPropertyChangeListener() {
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("visible".equals(propertyChangeEvent.getPropertyName())) {
                        ColumnVisibilityAction.this.updateSelected();
                    } else if ("headerValue".equals(propertyChangeEvent.getPropertyName())) {
                        ColumnVisibilityAction.this.setName(String.valueOf(propertyChangeEvent.getNewValue()));
                    }
                }
            };
            return propertyChangeListener;
        }
    }
}

