/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import org.jdesktop.swingx.action.Targetable;

public class TargetManager {
    private static TargetManager INSTANCE;
    private List targetList;
    private Targetable target;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    public static TargetManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TargetManager();
        }
        return INSTANCE;
    }

    public void addTarget(Targetable targetable, boolean bl) {
        if (this.targetList == null) {
            this.targetList = new ArrayList();
        }
        if (bl) {
            this.targetList.add(0, targetable);
        } else {
            this.targetList.add(targetable);
        }
    }

    public void addTarget(Targetable targetable) {
        this.addTarget(targetable, false);
    }

    public void removeTarget(Targetable targetable) {
        if (this.targetList != null) {
            this.targetList.remove(targetable);
        }
    }

    public Targetable[] getTargets() {
        Targetable[] targetableArray;
        if (this.targetList == null) {
            targetableArray = new Targetable[]{};
        } else {
            targetableArray = new Targetable[this.targetList.size()];
            targetableArray = this.targetList.toArray(new Targetable[this.targetList.size()]);
        }
        return targetableArray;
    }

    public void setTarget(Targetable targetable) {
        Targetable targetable2 = this.target;
        if (targetable2 != targetable) {
            this.target = targetable;
            this.propertySupport.firePropertyChange("target", targetable2, targetable);
        }
    }

    public Targetable getTarget() {
        return this.target;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public boolean doCommand(Object object, Object object2) {
        if (this.target != null && this.target.hasCommand(object) && this.target.doCommand(object, object2)) {
            return true;
        }
        if (this.targetList != null) {
            for (Object object3 : this.targetList) {
                if (!object3.hasCommand(object) || !object3.doCommand(object, object2)) continue;
                return true;
            }
        }
        Object object4 = null;
        if (object2 instanceof ActionEvent) {
            object4 = (ActionEvent)object2;
        }
        for (Object object3 = FocusManager.getCurrentManager().getPermanentFocusOwner(); object3 != null; object3 = ((Component)object3).getParent()) {
            ActionMap actionMap;
            Action action;
            if (!(object3 instanceof JComponent) || (action = (actionMap = ((JComponent)object3).getActionMap()).get(object)) == null) continue;
            if (object4 == null) {
                object4 = new ActionEvent(object3, 0, object.toString());
            }
            action.actionPerformed((ActionEvent)object4);
            return true;
        }
        return false;
    }

    void reset() {
        if (this.targetList != null) {
            this.targetList.clear();
            this.targetList = null;
        }
        this.target = null;
        PropertyChangeListener[] propertyChangeListenerArray = this.propertySupport.getPropertyChangeListeners();
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            this.propertySupport.removePropertyChangeListener(propertyChangeListenerArray[i]);
        }
        INSTANCE = null;
    }
}

