/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionManager;
import org.jdesktop.swingx.action.ToggleActionPropertyChangeListener;

public class ActionContainerFactory {
    private static Insets TOOLBAR_BUTTON_MARGIN = new Insets(1, 1, 1, 1);
    private ActionManager manager;
    private Map groupMap;

    public ActionContainerFactory(ActionManager actionManager) {
        this.setActionManager(actionManager);
    }

    public ActionManager getActionManager() {
        if (this.manager == null) {
            this.manager = ActionManager.getInstance();
        }
        return this.manager;
    }

    public void setActionManager(ActionManager actionManager) {
        ActionManager actionManager2 = this.manager;
        if (actionManager2 != null) {
            actionManager2.setFactory(null);
        }
        this.manager = actionManager;
        if (actionManager != null) {
            actionManager.setFactory(this);
        }
    }

    private JToolBar createToolBar(Object[] objectArray) {
        return this.createToolBar(Arrays.asList(objectArray));
    }

    public JToolBar createToolBar(List list) {
        JToolBar jToolBar = new JToolBar();
        for (Object e : list) {
            if (e == null) {
                jToolBar.addSeparator();
                continue;
            }
            AbstractButton abstractButton = this.createButton(e, (JComponent)jToolBar);
            abstractButton.setFocusable(false);
            abstractButton.setMargin(TOOLBAR_BUTTON_MARGIN);
            abstractButton.setBorderPainted(false);
            jToolBar.add(abstractButton);
        }
        return jToolBar;
    }

    private JPopupMenu createPopup(Object[] objectArray) {
        return this.createPopup(Arrays.asList(objectArray));
    }

    public JPopupMenu createPopup(List list) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (Object e : list) {
            if (e == null) {
                jPopupMenu.addSeparator();
                continue;
            }
            if (e instanceof List) {
                JMenu jMenu = this.createMenu((List)e);
                if (jMenu == null) continue;
                jPopupMenu.add(jMenu);
                continue;
            }
            jPopupMenu.add(this.createMenuItem(e, (JComponent)jPopupMenu));
        }
        return jPopupMenu;
    }

    public JMenuBar createMenuBar(List list) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        for (Object e : list) {
            if (e == null) {
                if (jMenu == null) continue;
                jMenu.addSeparator();
                continue;
            }
            if (e instanceof List) {
                jMenu = this.createMenu((List)e);
                if (jMenu == null) continue;
                jMenuBar.add(jMenu);
                continue;
            }
            if (jMenu == null) continue;
            jMenu.add(this.createMenuItem(e, (JComponent)jMenu));
        }
        return jMenuBar;
    }

    public JMenu createMenu(List list) {
        Action action = this.getAction(list.get(0));
        if (action == null) {
            return null;
        }
        JMenu jMenu = new JMenu(action);
        ListIterator listIterator = list.listIterator(1);
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (e == null) {
                jMenu.addSeparator();
                continue;
            }
            if (e instanceof List) {
                JMenu jMenu2 = this.createMenu((List)e);
                if (jMenu2 == null) continue;
                jMenu.add(jMenu2);
                continue;
            }
            jMenu.add(this.createMenuItem(e, (JComponent)jMenu));
        }
        return jMenu;
    }

    private Action getAction(Object object) {
        Action action = this.getActionManager().getAction(object);
        if (action == null) {
            throw new RuntimeException("ERROR: No Action for " + object);
        }
        return action;
    }

    private ButtonGroup getGroup(String string, JComponent jComponent) {
        Integer n;
        ButtonGroup buttonGroup;
        if (this.groupMap == null) {
            this.groupMap = new HashMap();
        }
        int n2 = string.hashCode();
        if (jComponent != null) {
            n2 ^= jComponent.hashCode();
        }
        if ((buttonGroup = (ButtonGroup)this.groupMap.get(n = new Integer(n2))) == null) {
            buttonGroup = new ButtonGroup();
            this.groupMap.put(n, buttonGroup);
        }
        return buttonGroup;
    }

    private JMenuItem createMenuItem(Object object, JComponent jComponent) {
        return this.createMenuItem(this.getAction(object), jComponent);
    }

    public JMenuItem createMenuItem(Action action, JComponent jComponent) {
        AbstractActionExt abstractActionExt;
        JMenuItem jMenuItem = null;
        if (action instanceof AbstractActionExt && (abstractActionExt = (AbstractActionExt)action).isStateAction()) {
            String string = (String)abstractActionExt.getGroup();
            jMenuItem = string != null ? this.createRadioButtonMenuItem(this.getGroup(string, jComponent), (AbstractActionExt)action) : this.createCheckBoxMenuItem((AbstractActionExt)action);
        }
        if (jMenuItem == null) {
            jMenuItem = new JMenuItem(action);
            this.configureMenuItem(jMenuItem, action);
        }
        return jMenuItem;
    }

    public JMenuItem createMenuItem(Action action) {
        return this.createMenuItem(action, null);
    }

    private AbstractButton createButton(Object object, JComponent jComponent) {
        return this.createButton(this.getAction(object), jComponent);
    }

    public AbstractButton createButton(Action action, JComponent jComponent) {
        AbstractActionExt abstractActionExt;
        if (action == null) {
            return null;
        }
        AbstractButton abstractButton = null;
        if (action instanceof AbstractActionExt && (abstractActionExt = (AbstractActionExt)action).isStateAction()) {
            String string = (String)abstractActionExt.getGroup();
            abstractButton = string == null ? this.createToggleButton(abstractActionExt) : this.createToggleButton(abstractActionExt, this.getGroup(string, jComponent));
        }
        if (abstractButton == null) {
            abstractButton = new JButton(action);
            this.configureButton(abstractButton, action);
        }
        return abstractButton;
    }

    public AbstractButton createButton(Action action) {
        return this.createButton(action, null);
    }

    private JToggleButton createToggleButton(AbstractActionExt abstractActionExt) {
        return this.createToggleButton(abstractActionExt, null);
    }

    private JToggleButton createToggleButton(AbstractActionExt abstractActionExt, ButtonGroup buttonGroup) {
        JToggleButton jToggleButton = new JToggleButton();
        this.configureButton(jToggleButton, abstractActionExt, buttonGroup);
        return jToggleButton;
    }

    public void configureButton(JToggleButton jToggleButton, AbstractActionExt abstractActionExt, ButtonGroup buttonGroup) {
        jToggleButton.setAction(abstractActionExt);
        jToggleButton.addItemListener(abstractActionExt);
        jToggleButton.setSelected(abstractActionExt.isSelected());
        if (buttonGroup != null) {
            buttonGroup.add(jToggleButton);
        }
        this.configureToggleButton(jToggleButton, abstractActionExt);
    }

    protected void configureToggleButton(JToggleButton jToggleButton, Action action) {
        this.configureButton(jToggleButton, action);
        action.addPropertyChangeListener(new ToggleActionPropertyChangeListener(jToggleButton));
    }

    protected void configureButton(AbstractButton abstractButton, Action action) {
        if (action.getValue("ShortDescription") == null) {
            abstractButton.setToolTipText((String)action.getValue("Name"));
        }
        if (action.getValue("__LargeIcon__") != null) {
            abstractButton.setIcon((Icon)action.getValue("__LargeIcon__"));
        }
        if (abstractButton.getIcon() != null) {
            abstractButton.setText("");
        }
    }

    protected void configureToggleMenuItem(JMenuItem jMenuItem, Action action) {
        this.configureMenuItem(jMenuItem, action);
        action.addPropertyChangeListener(new ToggleActionPropertyChangeListener(jMenuItem));
    }

    protected void configureMenuItem(JMenuItem jMenuItem, Action action) {
    }

    private JCheckBoxMenuItem createCheckBoxMenuItem(AbstractActionExt abstractActionExt) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(abstractActionExt);
        jCheckBoxMenuItem.addItemListener(abstractActionExt);
        jCheckBoxMenuItem.setSelected(abstractActionExt.isSelected());
        this.configureToggleMenuItem(jCheckBoxMenuItem, abstractActionExt);
        return jCheckBoxMenuItem;
    }

    private JRadioButtonMenuItem createRadioButtonMenuItem(ButtonGroup buttonGroup, AbstractActionExt abstractActionExt) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(abstractActionExt);
        jRadioButtonMenuItem.addItemListener(abstractActionExt);
        jRadioButtonMenuItem.setSelected(abstractActionExt.isSelected());
        if (buttonGroup != null) {
            buttonGroup.add(jRadioButtonMenuItem);
        }
        this.configureToggleMenuItem(jRadioButtonMenuItem, abstractActionExt);
        return jRadioButtonMenuItem;
    }
}

