/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class RolloverProducer
implements MouseListener,
MouseMotionListener {
    public static final String CLICKED_KEY = "swingx.clicked";
    public static final String ROLLOVER_KEY = "swingx.rollover";
    protected Point rollover = new Point(-1, -1);

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateRollover(mouseEvent, CLICKED_KEY);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateRollover(mouseEvent, ROLLOVER_KEY);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JComponent) {
            ((JComponent)mouseEvent.getSource()).putClientProperty(ROLLOVER_KEY, null);
            ((JComponent)mouseEvent.getSource()).putClientProperty(CLICKED_KEY, null);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateRollover(mouseEvent, ROLLOVER_KEY);
    }

    protected void updateRollover(MouseEvent mouseEvent, String string) {
        this.updateRolloverPoint((JComponent)mouseEvent.getComponent(), mouseEvent.getPoint());
        this.updateClientProperty((JComponent)mouseEvent.getSource(), string);
    }

    protected void updateClientProperty(JComponent jComponent, String string) {
        Point point = (Point)jComponent.getClientProperty(string);
        if (point == null || this.rollover.x != point.x || this.rollover.y != point.y) {
            jComponent.putClientProperty(string, new Point(this.rollover));
        }
    }

    protected void updateRolloverPoint(JComponent jComponent, Point point) {
    }
}

