/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import org.jdesktop.swingx.RepaintManagerX;
import org.jdesktop.swingx.TranslucentRepaintManager;

public class JXPanel
extends JPanel
implements Scrollable {
    private boolean scrollableTracksViewportHeight;
    private boolean scrollableTracksViewportWidth;
    private float alpha = 1.0f;
    private boolean oldOpaque;
    private boolean inheritAlpha = true;
    private boolean drawGradient = false;
    private boolean gradientTrackWidth = true;
    private boolean gradientTrackHeight = true;
    private GradientPaint gradientPaint;
    private Dimension oldSize;
    private BufferedImage cachedGradient;

    public JXPanel() {
    }

    public JXPanel(boolean bl) {
        super(bl);
    }

    public JXPanel(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public JXPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    public void setAlpha(float f) {
        if (this.alpha != f) {
            assert (f >= 0.0f && (double)f <= 1.0);
            float f2 = this.alpha;
            this.alpha = f;
            if (f > 0.0f && f < 1.0f) {
                if (f2 == 1.0f) {
                    this.oldOpaque = this.isOpaque();
                    this.setOpaque(false);
                }
                if (!(RepaintManager.currentManager(this) instanceof TranslucentRepaintManager)) {
                    RepaintManager.setCurrentManager(new RepaintManagerX());
                }
            } else if (f == 1.0f && this.oldOpaque) {
                this.setOpaque(true);
            }
            this.firePropertyChange("alpha", f2, f);
            this.repaint();
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getEffectiveAlpha() {
        if (this.inheritAlpha) {
            float f = this.alpha;
            Container container = this;
            while ((container = container.getParent()) != null) {
                if (!(container instanceof JXPanel)) continue;
                f = Math.min(((JXPanel)container).getAlpha(), f);
            }
            return f;
        }
        return this.alpha;
    }

    public boolean isInheritAlpha() {
        return this.inheritAlpha;
    }

    public void setInheritAlpha(boolean bl) {
        if (this.inheritAlpha != bl) {
            this.inheritAlpha = bl;
            this.firePropertyChange("inheritAlpha", !this.inheritAlpha, this.inheritAlpha);
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.scrollableTracksViewportHeight;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.scrollableTracksViewportWidth;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public void setScrollableTracksViewportHeight(boolean bl) {
        this.scrollableTracksViewportHeight = bl;
    }

    public void setScrollableTracksViewportWidth(boolean bl) {
        this.scrollableTracksViewportWidth = bl;
    }

    public void setGradientPaint(GradientPaint gradientPaint) {
        GradientPaint gradientPaint2 = this.gradientPaint;
        this.gradientPaint = gradientPaint;
        this.firePropertyChange("gradientPaint", gradientPaint2, gradientPaint);
        this.repaint();
    }

    public GradientPaint getGradientPaint() {
        return this.gradientPaint;
    }

    public void setDrawGradient(boolean bl) {
        if (this.drawGradient != bl) {
            boolean bl2 = this.drawGradient;
            this.drawGradient = bl;
            this.oldSize = this.getSize();
            this.firePropertyChange("drawGradient", bl2, bl);
            this.repaint();
        }
    }

    public boolean isDrawGradient() {
        return this.drawGradient;
    }

    public void setGradientTrackWidth(boolean bl) {
        if (this.gradientTrackWidth != bl) {
            boolean bl2 = this.gradientTrackWidth;
            this.gradientTrackWidth = bl;
            this.firePropertyChange("gradientTrackWidth", bl2, bl);
            this.repaint();
        }
    }

    public boolean isGradientTrackWidth() {
        return this.gradientTrackWidth;
    }

    public void setGradientTrackHeight(boolean bl) {
        if (this.gradientTrackHeight != bl) {
            boolean bl2 = this.gradientTrackHeight;
            this.gradientTrackHeight = bl;
            this.firePropertyChange("gradientTrackHeight", bl2, bl);
            this.repaint();
        }
    }

    public boolean isGradientTrackHeight() {
        return this.gradientTrackHeight;
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = this.getEffectiveAlpha();
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, f);
        graphics2D.setComposite(alphaComposite);
        super.paint(graphics2D);
        graphics2D.setComposite(composite);
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.drawGradient) {
            Object object;
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.right - insets.left;
            int n2 = this.getHeight() - insets.top - insets.bottom;
            if (this.gradientPaint == null || this.oldSize == null || this.oldSize.width != n || this.oldSize.height != n2) {
                object = null;
                Color color = null;
                if (this.gradientPaint == null) {
                    object = this.getBackground();
                    color = new Color(((Color)object).getRed() - 40, ((Color)object).getGreen() - 40, ((Color)object).getBlue() - 40);
                    float f = 0.0f;
                    float f2 = 0.0f;
                    float f3 = n;
                    float f4 = 0.0f;
                    boolean bl = false;
                    this.gradientPaint = new GradientPaint(f, f2, (Color)object, f3, f4, color, bl);
                } else {
                    float f;
                    GradientPaint gradientPaint = this.gradientPaint;
                    float f5 = (float)gradientPaint.getPoint2().getX();
                    if (this.gradientTrackWidth) {
                        f = (float)n / (float)this.oldSize.width;
                        f5 = (float)gradientPaint.getPoint2().getX() * f;
                    }
                    f = (float)gradientPaint.getPoint2().getY();
                    if (this.gradientTrackHeight) {
                        float f6 = (float)n2 / (float)this.oldSize.height;
                        f = (float)gradientPaint.getPoint2().getY() * f6;
                    }
                    this.gradientPaint = new GradientPaint((float)gradientPaint.getPoint1().getX(), (float)gradientPaint.getPoint1().getY(), gradientPaint.getColor1(), f5, f, gradientPaint.getColor2(), gradientPaint.isCyclic());
                }
                this.oldSize = new Dimension(n, n2);
                this.cachedGradient = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D = (Graphics2D)this.cachedGradient.getGraphics();
                graphics2D.setPaint(this.gradientPaint);
                graphics2D.fillRect(0, 0, n, n2);
            }
            object = (Graphics2D)graphics;
            ((Graphics2D)object).drawImage(this.cachedGradient, null, insets.left, insets.top);
        }
    }
}

