/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.calendar.DateSpan;
import org.jdesktop.swingx.calendar.JXMonthView;

public class JXDatePicker
extends JComponent {
    private JFormattedTextField _dateField;
    private JXDatePickerPopup _popup;
    private JPanel _linkPanel;
    private long _linkDate;
    private MessageFormat _linkFormat;
    private JButton _popupButton;
    private int _popupButtonWidth = 20;
    private JXMonthView _monthView = new JXMonthView();
    private Handler _handler;
    private String _actionCommand = "selectionChanged";

    public JXDatePicker() {
        this(System.currentTimeMillis());
    }

    public JXDatePicker(long l) {
        this._monthView.setTraversable(true);
        this._dateField = this.createEditor();
        this._dateField.setName("dateField");
        this._dateField.setBorder(null);
        this._handler = new Handler();
        this._popupButton = new JButton();
        this._popupButton.setName("popupButton");
        this._popupButton.setRolloverEnabled(false);
        this._popupButton.addMouseListener(this._handler);
        this._popupButton.addMouseMotionListener(this._handler);
        JComboBox jComboBox = new JComboBox();
        Object object = jComboBox.getClientProperty("doNotCancelPopup");
        this._popupButton.putClientProperty("doNotCancelPopup", object);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0, false);
        InputMap inputMap = this._dateField.getInputMap(0);
        inputMap.put(keyStroke, "COMMIT_EDIT");
        ActionMap actionMap = this._dateField.getActionMap();
        actionMap.put("COMMIT_EDIT", new CommitEditAction());
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(32, 0, false);
        inputMap = this._popupButton.getInputMap(0);
        inputMap.put(keyStroke2, "TOGGLE_POPUP");
        actionMap = this._popupButton.getActionMap();
        actionMap.put("TOGGLE_POPUP", new TogglePopupAction());
        this.add(this._dateField);
        this.add(this._popupButton);
        this.updateUI();
        this._linkDate = System.currentTimeMillis();
        this._linkPanel = new TodayPanel();
        this._dateField.setValue(new Date(l));
    }

    public void updateUI() {
        int n = UIManager.getInt("JXDatePicker.numColumns");
        if (n == -1) {
            n = 10;
        }
        this._dateField.setColumns(n);
        String string = UIManager.getString("JXDatePicker.arrowDown.tooltip");
        if (string == null) {
            string = "Show Calendar";
        }
        this._popupButton.setToolTipText(string);
        Icon icon = UIManager.getIcon("JXDatePicker.arrowDown.image");
        if (icon == null) {
            icon = (Icon)UIManager.get("Tree.expandedIcon");
        }
        this._popupButton.setIcon(icon);
        Border border = UIManager.getBorder("JXDatePicker.border");
        if (border == null) {
            border = BorderFactory.createCompoundBorder(LineBorder.createGrayLineBorder(), BorderFactory.createEmptyBorder(3, 3, 3, 3));
        }
        this._dateField.setBorder(border);
        String string2 = UIManager.getString("JXDatePicker.linkFormat");
        if (string2 == null) {
            string2 = "Today is {0,date, dd MMMM yyyy}";
        }
        this._linkFormat = new MessageFormat(string2);
    }

    public void setFormats(String[] stringArray) {
        DateFormat[] dateFormatArray = new DateFormat[stringArray.length];
        for (int i = stringArray.length - 1; i >= 0; --i) {
            dateFormatArray[i] = new SimpleDateFormat(stringArray[i]);
        }
        this.setFormats(dateFormatArray);
    }

    public void setFormats(DateFormat[] dateFormatArray) {
        this._dateField.setFormatterFactory(new DefaultFormatterFactory(new JXDatePickerFormatter(dateFormatArray)));
    }

    public DateFormat[] getFormats() {
        JFormattedTextField.AbstractFormatter abstractFormatter;
        JFormattedTextField.AbstractFormatterFactory abstractFormatterFactory = this._dateField.getFormatterFactory();
        if (abstractFormatterFactory != null && (abstractFormatter = abstractFormatterFactory.getFormatter(this._dateField)) instanceof JXDatePickerFormatter) {
            return ((JXDatePickerFormatter)abstractFormatter).getFormats();
        }
        return null;
    }

    public void setDate(Date date) {
        this._dateField.setValue(date);
    }

    public void setDateInMillis(long l) {
        this._dateField.setValue(new Date(l));
    }

    public Date getDate() {
        return (Date)this._dateField.getValue();
    }

    public long getDateInMillis() {
        return ((Date)this._dateField.getValue()).getTime();
    }

    public JXMonthView getMonthView() {
        return this._monthView;
    }

    public void setMonthView(JXMonthView jXMonthView) {
        this._monthView = jXMonthView;
        this._popup = null;
    }

    public TimeZone getTimeZone() {
        return this._monthView.getTimeZone();
    }

    public void setTimeZone(TimeZone timeZone) {
        this._monthView.setTimeZone(timeZone);
    }

    public void setLinkDate(long l, String string) {
        this._linkDate = l;
        this._linkFormat = new MessageFormat(string);
        this.setLinkPanel(new TodayPanel());
    }

    public JPanel getLinkPanel() {
        return this._linkPanel;
    }

    public void setLinkPanel(JPanel jPanel) {
        if (this._popup != null) {
            this._popup.remove(this._linkPanel);
            this._popup.add((Component)jPanel, "South");
        }
        this._linkPanel = jPanel;
    }

    public JFormattedTextField getEditor() {
        return this._dateField;
    }

    protected JFormattedTextField createEditor() {
        return new JFormattedTextField(new JXDatePickerFormatter());
    }

    public boolean isEditValid() {
        return this._dateField.isEditValid();
    }

    public void commitEdit() throws ParseException {
        this._dateField.commitEdit();
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled() == bl) {
            return;
        }
        super.setEnabled(bl);
        this._dateField.setEnabled(bl);
        this._popupButton.setEnabled(bl);
    }

    public String getActionCommand() {
        return this._actionCommand;
    }

    public void setActionCommand(String string) {
        this._actionCommand = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    protected void fireActionPerformed() {
        Object[] objectArray = this.listenerList.getListenerList();
        ActionEvent actionEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActionListener.class) continue;
            if (actionEvent == null) {
                actionEvent = new ActionEvent(this, 1001, this._actionCommand);
            }
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        this._dateField.setBounds(insets.left, insets.bottom, n - this._popupButtonWidth, n2);
        this._popupButton.setBounds(n - this._popupButtonWidth + insets.left, insets.bottom, this._popupButtonWidth, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this._dateField.getPreferredSize();
        dimension.width += this._popupButton.getPreferredSize().width;
        Insets insets = this.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    static class JXDatePickerFormatter
    extends JFormattedTextField.AbstractFormatter {
        private DateFormat[] _formats = null;

        public JXDatePickerFormatter() {
            this._formats = new DateFormat[3];
            String string = UIManager.getString("JXDatePicker.longFormat");
            if (string == null) {
                string = "EEE MM/dd/yyyy";
            }
            this._formats[0] = new SimpleDateFormat(string);
            string = UIManager.getString("JXDatePicker.mediumFormat");
            if (string == null) {
                string = "MM/dd/yyyy";
            }
            this._formats[1] = new SimpleDateFormat(string);
            string = UIManager.getString("JXDatePicker.shortFormat");
            if (string == null) {
                string = "MM/dd";
            }
            this._formats[2] = new SimpleDateFormat(string);
        }

        public JXDatePickerFormatter(DateFormat[] dateFormatArray) {
            this._formats = dateFormatArray;
        }

        public DateFormat[] getFormats() {
            return this._formats;
        }

        public Object stringToValue(String string) throws ParseException {
            Date date = null;
            ParseException parseException = null;
            if (string == null || string.trim().length() == 0) {
                return null;
            }
            for (DateFormat dateFormat : this._formats) {
                try {
                    date = dateFormat.parse(string);
                    parseException = null;
                    break;
                }
                catch (ParseException parseException2) {
                    parseException = parseException2;
                }
            }
            if (parseException != null) {
                throw parseException;
            }
            return date;
        }

        public String valueToString(Object object) throws ParseException {
            if (object != null) {
                return this._formats[0].format(object);
            }
            return null;
        }
    }

    private final class TodayPanel
    extends JXPanel {
        TodayPanel() {
            super(new FlowLayout());
            this.setDrawGradient(true);
            this.setGradientPaint(new GradientPaint(0.0f, 0.0f, new Color(238, 238, 238), 0.0f, 1.0f, Color.WHITE));
            JXHyperlink jXHyperlink = new JXHyperlink(new TodayAction());
            Color color = new Color(16, 66, 104);
            jXHyperlink.setUnclickedColor(color);
            jXHyperlink.setClickedColor(color);
            this.add(jXHyperlink);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(new Color(187, 187, 187));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(new Color(221, 221, 221));
            graphics.drawLine(0, 1, this.getWidth(), 1);
        }

        private final class TodayAction
        extends AbstractAction {
            TodayAction() {
                super(JXDatePicker.this._linkFormat.format(new Object[]{new Date(JXDatePicker.this._linkDate)}));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DateSpan dateSpan = new DateSpan(JXDatePicker.this._linkDate, JXDatePicker.this._linkDate);
                JXDatePicker.this._monthView.ensureDateVisible(dateSpan.getStart());
            }
        }
    }

    protected class JXDatePickerPopup
    extends JPopupMenu
    implements ActionListener {
        public JXDatePickerPopup() {
            JXDatePicker.this._monthView.setActionCommand("MONTH_VIEW");
            JXDatePicker.this._monthView.addActionListener(this);
            this.setLayout(new BorderLayout());
            this.add((Component)JXDatePicker.this._monthView, "Center");
            if (JXDatePicker.this._linkPanel != null) {
                this.add((Component)JXDatePicker.this._linkPanel, "South");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if ("MONTH_VIEW".equals(string)) {
                DateSpan dateSpan = JXDatePicker.this._monthView.getSelectedDateSpan();
                JXDatePicker.this._dateField.setValue(dateSpan.getStartAsDate());
                JXDatePicker.this._popup.setVisible(false);
                JXDatePicker.this.fireActionPerformed();
            }
        }
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener {
        private boolean _forwardReleaseEvent = false;

        private Handler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!JXDatePicker.this.isEnabled()) {
                return;
            }
            if (JXDatePicker.this._dateField.isEditValid()) {
                try {
                    JXDatePicker.this._dateField.commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.toggleShowPopup();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!JXDatePicker.this.isEnabled()) {
                return;
            }
            if (this._forwardReleaseEvent) {
                mouseEvent = SwingUtilities.convertMouseEvent(JXDatePicker.this._popupButton, mouseEvent, JXDatePicker.this._monthView);
                JXDatePicker.this._monthView.dispatchEvent(mouseEvent);
                this._forwardReleaseEvent = false;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!JXDatePicker.this.isEnabled()) {
                return;
            }
            this._forwardReleaseEvent = true;
            if (!JXDatePicker.this._popup.isShowing()) {
                return;
            }
            mouseEvent = SwingUtilities.convertMouseEvent(JXDatePicker.this._popupButton, mouseEvent, JXDatePicker.this._monthView);
            JXDatePicker.this._monthView.dispatchEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void toggleShowPopup() {
            if (JXDatePicker.this._popup == null) {
                JXDatePicker.this._popup = new JXDatePickerPopup();
            }
            if (!JXDatePicker.this._popup.isVisible()) {
                if (JXDatePicker.this._dateField.getValue() == null) {
                    JXDatePicker.this._dateField.setValue(new Date(JXDatePicker.this._linkDate));
                }
                DateSpan dateSpan = new DateSpan((Date)JXDatePicker.this._dateField.getValue(), (Date)JXDatePicker.this._dateField.getValue());
                JXDatePicker.this._monthView.setSelectedDateSpan(dateSpan);
                JXDatePicker.this._monthView.ensureDateVisible(((Date)JXDatePicker.this._dateField.getValue()).getTime());
                JXDatePicker.this._popup.show(JXDatePicker.this, 0, JXDatePicker.this.getHeight());
            } else {
                JXDatePicker.this._popup.setVisible(false);
            }
        }
    }

    private class CommitEditAction
    extends AbstractAction {
        public CommitEditAction() {
            super("CommitEditPopup");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                JXDatePicker.this._dateField.commitEdit();
                JXDatePicker.this._dateField.setValue(JXDatePicker.this._dateField.getValue());
                JXDatePicker.this.fireActionPerformed();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private class TogglePopupAction
    extends AbstractAction {
        public TogglePopupAction() {
            super("TogglePopup");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JXDatePicker.this._handler.toggleShowPopup();
        }
    }
}

