/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.provider.sql;

import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.dataset.DataCommand;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.provider.sql.JDBCDataConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSqlCommand
extends DataCommand {
    private static final Logger LOG = Logger.getLogger(AbstractSqlCommand.class.getName());

    protected abstract PreparedStatement getSelectStatement(JDBCDataConnection var1) throws Exception;

    protected abstract PreparedStatement getInsertStatement(JDBCDataConnection var1, DataRow var2) throws Exception;

    protected abstract PreparedStatement getUpdateStatement(JDBCDataConnection var1, DataRow var2) throws Exception;

    protected abstract PreparedStatement getDeleteStatement(JDBCDataConnection var1, DataRow var2) throws Exception;

    protected String constructSql(String string, Map<String, List<Integer>> map) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (c == '\'') {
                bl = !bl;
                continue;
            }
            if (c == '\"') {
                bl2 = !bl2;
                continue;
            }
            if (c != ':' || bl || bl2) continue;
            int n2 = i++;
            boolean bl3 = false;
            while (!bl3) {
                if (i >= stringBuilder.length()) {
                    bl3 = true;
                } else {
                    char c2 = stringBuilder.charAt(i);
                    if (c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r' || c2 == ',' || c2 == ')') {
                        bl3 = true;
                    }
                }
                ++i;
            }
            String string2 = stringBuilder.substring(n2 + 1, i - 1);
            stringBuilder.replace(n2, i - 1, "?");
            if (!map.containsKey(string2)) {
                map.put(string2, new ArrayList());
            }
            List<Integer> list = map.get(string2);
            list.add(n++);
            i = n2 + 1;
        }
        return stringBuilder.toString();
    }

    protected PreparedStatement prepareStatement(String string, Map<String, Object> map, JDBCDataConnection jDBCDataConnection) throws Exception {
        HashMap<String, List<Integer>> hashMap = new HashMap<String, List<Integer>>();
        PreparedStatement preparedStatement = jDBCDataConnection.prepareStatement(this.constructSql(string, hashMap));
        for (String string2 : this.getParameterNames()) {
            map.put(string2, super.getParameter(string2));
        }
        for (String string2 : this.getParameterNames(new String[]{string})) {
            List list = (List)hashMap.get(string2);
            if (list == null) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "Index: {0}, ParamName: {1}, ParamValue: {2}", new Object[]{n + 1, string2, map.get(string2)});
                }
                preparedStatement.setObject(n + 1, map.get(string2));
            }
        }
        return preparedStatement;
    }

    public String[] getParameterNames(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        HashSet hashSet = new HashSet();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char c = stringBuilder.charAt(i);
            if (c == '\'') {
                n = n == 0 ? 1 : 0;
                continue;
            }
            if (c == '\"') {
                n2 = n2 == 0 ? 1 : 0;
                continue;
            }
            if (c != ':' || n != 0 || n2 != 0) continue;
            int n3 = i++;
            boolean bl = false;
            while (!bl) {
                if (i >= stringBuilder.length()) {
                    bl = true;
                } else {
                    char c2 = stringBuilder.charAt(i);
                    if (c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r' || c2 == ',' || c2 == ')') {
                        bl = true;
                    }
                }
                ++i;
            }
            String string = stringBuilder.substring(n3 + 1, i - 1);
            hashSet.add(string);
        }
        String[] stringArray2 = new String[hashSet.size()];
        return hashSet.toArray(stringArray2);
    }
}

