/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.provider;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.provider.AbstractTask;

public abstract class LoadTask
extends AbstractTask {
    private static final Logger LOG = Logger.getLogger(LoadTask.class.getName());
    private LinkedList loadQueue = new LinkedList();
    private LoadNotifier loadNotifier = new LoadNotifier();
    private DataTable[] tables;
    private boolean loadOnEDT = true;

    public void setLoadOnEDT(boolean bl) {
        this.loadOnEDT = bl;
    }

    public LoadTask(DataTable[] dataTableArray) {
        this.tables = dataTableArray == null ? new DataTable[]{} : dataTableArray;
    }

    public void run() {
        this.setIndeterminate(true);
        try {
            this.readData(this.tables);
            this.scheduleLoad();
            this.setProgress(this.getMaximum());
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            LOG.log(Level.WARNING, "Failed to load data into tables {0}. {1}", new Object[]{this.tables, exception.getStackTrace()});
            this.setProgress(this.getMaximum());
        }
    }

    protected abstract void readData(DataTable[] var1) throws Exception;

    protected abstract void loadData(LoadItem[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleLoad(LoadItem loadItem) {
        LinkedList linkedList = this.loadQueue;
        synchronized (linkedList) {
            if (loadItem != null) {
                this.loadQueue.addLast(loadItem);
            }
            if (!this.loadNotifier.isPending()) {
                this.loadNotifier.setPending(true);
                if (this.loadOnEDT) {
                    SwingUtilities.invokeLater(this.loadNotifier);
                } else {
                    this.loadNotifier.run();
                }
            }
        }
    }

    protected void scheduleLoad() {
        this.scheduleLoad(null);
    }

    public String getDescription() {
        return "<html><h3>Loading data</h3></html>";
    }

    public Icon getIcon() {
        return null;
    }

    public String getMessage() {
        return "Loading item " + (this.getProgress() + 1) + " of " + this.getMaximum();
    }

    public boolean cancel() throws Exception {
        return false;
    }

    private class LoadNotifier
    implements Runnable {
        private boolean pending = false;

        LoadNotifier() {
        }

        public synchronized void setPending(boolean bl) {
            this.pending = bl;
        }

        public synchronized boolean isPending() {
            return this.pending;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LinkedList linkedList = LoadTask.this.loadQueue;
            synchronized (linkedList) {
                if (LoadTask.this.loadQueue.size() > 0) {
                    LoadItem[] loadItemArray = LoadTask.this.loadQueue.toArray(new LoadItem[LoadTask.this.loadQueue.size()]);
                    LoadTask.this.loadQueue.clear();
                    LoadTask.this.loadData(loadItemArray);
                }
                this.setPending(false);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LoadItem<E> {
        public DataTable table;
        public E data;

        public LoadItem(DataTable dataTable, E e) {
            this.table = dataTable;
            this.data = e;
        }
    }
}

