/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.adapter;

import java.util.List;
import org.jdesktop.binding.metadata.MetaData;
import org.jdesktop.binding.metadata.MetaDataProvider;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.event.DataTableListener;
import org.jdesktop.dataset.event.RowChangeEvent;
import org.jdesktop.dataset.event.TableChangeEvent;

public class MetaDataProviderAdapter
implements MetaDataProvider {
    private DataTable table;
    private MetaData[] cachedMetaData;
    private String[] cachedFieldNames;

    public MetaDataProviderAdapter(DataTable dataTable) {
        assert (dataTable != null);
        this.table = dataTable;
        this.initMetaData();
        dataTable.addDataTableListener(new DataTableListener(){

            public void rowChanged(RowChangeEvent rowChangeEvent) {
            }

            public void tableChanged(TableChangeEvent tableChangeEvent) {
                MetaDataProviderAdapter.this.initMetaData();
            }
        });
    }

    public int getFieldCount() {
        return this.cachedMetaData == null ? 0 : this.cachedMetaData.length;
    }

    public final String[] getFieldNames() {
        return this.cachedFieldNames == null ? new String[]{} : this.cachedFieldNames;
    }

    public final MetaData[] getMetaData() {
        return this.cachedMetaData == null ? new MetaData[]{} : this.cachedMetaData;
    }

    public MetaData getMetaData(String string) {
        if (this.cachedMetaData == null) {
            return new MetaData(string);
        }
        for (MetaData metaData : this.cachedMetaData) {
            if (!metaData.getName().equals(string)) continue;
            return metaData;
        }
        return null;
    }

    private void initMetaData() {
        List<DataColumn> list = this.table.getColumns();
        this.cachedMetaData = new MetaData[list.size()];
        this.cachedFieldNames = new String[this.cachedMetaData.length];
        for (int i = 0; i < this.cachedMetaData.length; ++i) {
            DataColumn dataColumn = list.get(i);
            this.cachedMetaData[i] = new MetaData(dataColumn.getName(), dataColumn.getType());
            this.cachedFieldNames[i] = dataColumn.getName();
        }
    }
}

