/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DataConnection {
    private static final Logger LOG = Logger.getLogger(DataConnection.class.getName());
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean connected = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(boolean bl) {
        if (bl && !this.connected) {
            try {
                LOG.fine("Attempting to connect to the data store");
                this.connect();
                this.connected = true;
                LOG.fine("Connected to the data store, firing property change event");
                this.pcs.firePropertyChange("connected", false, true);
            }
            catch (Exception exception) {
                LOG.log(Level.SEVERE, "Failed to connect to the data store.", exception);
                this.connected = false;
            }
        } else if (!bl && this.connected) {
            try {
                LOG.fine("Attempting to disconnect from the data store");
                this.disconnect();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Failed to physically disconnect from the data store, but will continue to logically disconnect from the data store.", exception);
            }
            finally {
                this.connected = false;
                LOG.fine("Logically disconnected from the data store, firing property change event");
                this.pcs.firePropertyChange("connected", true, false);
            }
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected abstract void connect() throws Exception;

    protected abstract void disconnect() throws Exception;

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }
}

