/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx.adapter;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import org.jdesktop.binding.metadata.Converter;

public class TabularDataMetaData {
    private Column[] columns;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public TabularDataMetaData() {
        this(0);
    }

    public TabularDataMetaData(int n) {
        this.setColumnCount(n);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void setColumnCount(int n) {
        int n2 = this.columns != null ? this.columns.length : 0;
        this.columns = new Column[n];
        for (int i = 0; i < n; ++i) {
            this.columns[i] = new Column("column" + i, String.class, true);
        }
        this.pcs.firePropertyChange("columnCount", n2, n);
    }

    public int getColumnCount() {
        return this.columns.length;
    }

    public int getColumnIndex(String string) {
        int n = 0;
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].name.equals(string)) continue;
            return i + 1;
        }
        return n;
    }

    public String getColumnName(int n) {
        return this.columns[n - 1].name;
    }

    public void setColumnName(int n, String string) {
        String string2 = this.columns[n - 1].name;
        this.columns[n - 1].name = string;
        this.pcs.firePropertyChange("columnName" + n, string2, string);
    }

    public String getColumnLabel(int n) {
        return this.columns[n - 1].label;
    }

    public void setColumnLabel(int n, String string) {
        String string2 = this.columns[n - 1].label;
        this.columns[n - 1].label = string;
        this.pcs.firePropertyChange("columnLabel" + n, string2, string);
    }

    public Class getColumnClass(int n) {
        return this.columns[n - 1].klass;
    }

    public void setColumnClass(int n, Class clazz) {
        Class clazz2 = this.columns[n - 1].klass;
        this.columns[n - 1].klass = clazz;
        this.pcs.firePropertyChange("columnClass" + n, clazz2, clazz);
    }

    public void setColumnDisplaySize(int n, int n2) {
        this.columns[n - 1].displayLength = n2;
    }

    public int getColumnDisplaySize(int n) {
        return this.columns[n - 1].displayLength;
    }

    public boolean isColumnWritable(int n) {
        return this.columns[n - 1].writable;
    }

    public void setColumnWritable(int n, boolean bl) {
        this.columns[n - 1].writable = bl;
    }

    public boolean isColumnNullable(int n) {
        return this.columns[n - 1].nullable;
    }

    public void setColumnNullable(int n, boolean bl) {
        this.columns[n - 1].nullable = bl;
    }

    public Object getColumnMinimum(int n) {
        return this.columns[n - 1].minimum;
    }

    public void setColumnMinimum(int n, Object object) {
        this.columns[n - 1].minimum = object;
    }

    public Object getColumnMaximum(int n) {
        return this.columns[n - 1].maximum;
    }

    public void setColumnMaximum(int n, Object object) {
        this.columns[n - 1].maximum = object;
    }

    public Iterator getColumnValues(int n) {
        final Object[] objectArray = new Object[this.columns[n - 1].values.length];
        System.arraycopy(this.columns[n - 1].values, 0, objectArray, 0, this.columns[n - 1].values.length);
        return new Iterator(){
            int current = 0;

            public boolean hasNext() {
                return this.current < objectArray.length;
            }

            public Object next() {
                return objectArray[this.current++];
            }

            public void remove() {
            }
        };
    }

    public void setColumnValues(int n, Object[] objectArray) {
        Object[] objectArray2 = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        this.columns[n - 1].values = objectArray2;
    }

    public void setColumnConverter(int n, Converter converter) {
        this.columns[n - 1].converter = converter;
    }

    public Converter getColumnConverter(int n) {
        return this.columns[n - 1].converter;
    }

    private class Column {
        public String name;
        public Class klass;
        public String label;
        public Converter converter;
        public boolean writable = false;
        public boolean nullable = false;
        public int displayLength = -1;
        public Object minimum;
        public Object maximum;
        public Object[] values;

        public Column(String string, Class clazz, boolean bl) {
            this.name = string;
            this.klass = clazz;
            this.writable = bl;
        }
    }
}

