/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.TabularDataModel;
import org.jdesktop.binding.metadata.EnumeratedMetaData;
import org.jdesktop.binding.metadata.SelectionInListMetaData;
import org.jdesktop.binding.swingx.AbstractBinding;
import org.jdesktop.binding.swingx.adapter.DataModelToComboBoxModelAdapter;

public class ComboBoxBinding
extends AbstractBinding {
    private JComboBox comboBox;

    public ComboBoxBinding(JComboBox jComboBox, DataModel dataModel, String string) {
        super(jComboBox, dataModel, string, 2);
    }

    public JComponent getComponent() {
        return this.comboBox;
    }

    protected void setComponent(JComponent jComponent) {
        this.comboBox = (JComboBox)jComponent;
        this.configureDropDown();
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ComboBoxBinding.this.pulling) {
                    ComboBoxBinding.this.setModified(true);
                }
            }
        });
    }

    protected void configureDropDown() {
        if (this.metaData instanceof EnumeratedMetaData) {
            this.updateComboBoxModel(((EnumeratedMetaData)this.metaData).getEnumeration());
        } else if (this.metaData instanceof SelectionInListMetaData) {
            this.updateComboBoxModel(((SelectionInListMetaData)this.metaData).getSourceDataModel());
        }
    }

    protected void updateComboBoxModel(TabularDataModel tabularDataModel) {
        DataModelToComboBoxModelAdapter dataModelToComboBoxModelAdapter = new DataModelToComboBoxModelAdapter(tabularDataModel, ((SelectionInListMetaData)this.metaData).getSourceFieldName());
        dataModelToComboBoxModelAdapter.setSelectedItem(this.getComponentValue());
        this.comboBox.setModel(dataModelToComboBoxModelAdapter);
        this.setValidState(0);
    }

    protected void updateComboBoxModel(Object[] objectArray) {
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        defaultComboBoxModel.setSelectedItem(this.getComponentValue());
        this.comboBox.setModel(defaultComboBoxModel);
        this.setValidState(0);
    }

    protected void installMetaDataListener() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("enumeration".equals(propertyChangeEvent.getPropertyName())) {
                    ComboBoxBinding.this.updateComboBoxModel((Object[])propertyChangeEvent.getNewValue());
                }
            }
        };
        this.metaData.addPropertyChangeListener(propertyChangeListener);
    }

    protected Object getComponentValue() {
        return this.comboBox.getSelectedItem();
    }

    protected void setComponentValue(Object object) {
        this.comboBox.getModel().setSelectedItem(object);
    }
}

