/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.metadata;

import java.util.Locale;
import org.jdesktop.binding.metadata.MetaData;
import org.jdesktop.binding.metadata.Validator;

public class NumberMetaData
extends MetaData {
    protected Number minimum = null;
    protected Number maximum = null;
    protected boolean currency = false;
    private Validator rangeValidator = null;

    public NumberMetaData() {
        this("numbervalue");
    }

    public NumberMetaData(String string) {
        super(string);
        this.klass = Integer.class;
    }

    public NumberMetaData(String string, Class clazz) {
        this(string);
        this.klass = clazz;
    }

    public NumberMetaData(String string, Class clazz, String string2) {
        this(string, clazz);
        this.label = string2;
    }

    public Number getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Number number) {
        if (this.klass != number.getClass()) {
            throw new IllegalArgumentException(this.getName() + ": minimum value is class " + number.getClass().getName() + " but should be " + this.getClass().getName());
        }
        Number number2 = this.minimum;
        this.minimum = number;
        this.setupRangeValidator();
        this.firePropertyChange("minimum", number2, number);
    }

    public Number getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Number number) {
        if (this.getElementClass() != number.getClass()) {
            throw new IllegalArgumentException(this.getName() + ": maximum value is class " + number.getClass().getName() + " but should be " + this.getClass().getName());
        }
        Number number2 = this.maximum;
        this.maximum = number;
        this.setupRangeValidator();
        this.firePropertyChange("maximum", number2, number);
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public void setCurrency(boolean bl) {
        boolean bl2 = this.currency;
        this.currency = bl;
        this.firePropertyChange("currency", bl2, bl);
    }

    private void setupRangeValidator() {
        if (this.maximum != null || this.minimum != null) {
            if (this.rangeValidator == null) {
                this.rangeValidator = this.getRangeValidator();
                this.addValidator(this.rangeValidator);
            }
        } else if (this.rangeValidator != null) {
            this.removeValidator(this.rangeValidator);
            this.rangeValidator = null;
        }
    }

    private Validator getRangeValidator() {
        if (this.klass.equals(Integer.class)) {
            return new IntegerRangeValidator();
        }
        if (this.klass.equals(Long.class)) {
            return new LongRangeValidator();
        }
        if (this.klass.equals(Float.class)) {
            return new FloatRangeValidator();
        }
        if (this.klass.equals(Short.class)) {
            return new ShortRangeValidator();
        }
        if (this.klass.equals(Double.class)) {
            return new DoubleRangeValidator();
        }
        return null;
    }

    private class DoubleRangeValidator
    implements Validator {
        private DoubleRangeValidator() {
        }

        public boolean validate(Object object, Locale locale, String[] stringArray) {
            double d = (Double)object;
            if (NumberMetaData.this.maximum != null && d > (Double)NumberMetaData.this.maximum) {
                stringArray[0] = NumberMetaData.this.getName() + ": value " + d + " exceeds maximum " + (Double)NumberMetaData.this.maximum;
                return false;
            }
            if (NumberMetaData.this.minimum != null && d < (Double)NumberMetaData.this.minimum) {
                stringArray[0] = NumberMetaData.this.getName() + ": value " + d + " is less than the minimum" + (Double)NumberMetaData.this.minimum;
                return false;
            }
            return true;
        }
    }

    private class FloatRangeValidator
    implements Validator {
        private FloatRangeValidator() {
        }

        public boolean validate(Object object, Locale locale, String[] stringArray) {
            float f = ((Float)object).floatValue();
            if (NumberMetaData.this.maximum != null && f > ((Float)NumberMetaData.this.maximum).floatValue()) {
                stringArray[0] = NumberMetaData.this.getName() + ": value " + f + " exceeds maximum " + ((Float)NumberMetaData.this.maximum).floatValue();
                return false;
            }
            if (NumberMetaData.this.minimum != null && f < ((Float)NumberMetaData.this.minimum).floatValue()) {
                stringArray[0] = NumberMetaData.this.getName() + ": value " + f + " is less than the minimum" + ((Float)NumberMetaData.this.minimum).floatValue();
                return false;
            }
            return true;
        }
    }

    private class ShortRangeValidator
    implements Validator {
        private ShortRangeValidator() {
        }

        public boolean validate(Object object, Locale locale, String[] stringArray) {
            short s = (Short)object;
            if (NumberMetaData.this.maximum != null && s > (Short)NumberMetaData.this.maximum) {
                stringArray[0] = NumberMetaData.this.getName() + ": value " + s + " exceeds maximum " + (Short)NumberMetaData.this.maximum;
                return false;
            }
            if (NumberMetaData.this.minimum != null && s < (Short)NumberMetaData.this.minimum) {
                stringArray[0] = NumberMetaData.this.getName() + ": value " + s + " is less than the minimum" + (Short)NumberMetaData.this.minimum;
                return false;
            }
            return true;
        }
    }

    private class LongRangeValidator
    implements Validator {
        private LongRangeValidator() {
        }

        public boolean validate(Object object, Locale locale, String[] stringArray) {
            long l = (Long)object;
            if (NumberMetaData.this.maximum != null && l > (Long)NumberMetaData.this.maximum) {
                stringArray[0] = NumberMetaData.this.getName() + ": value " + l + " exceeds maximum " + (Long)NumberMetaData.this.maximum;
                return false;
            }
            if (NumberMetaData.this.minimum != null && l < (Long)NumberMetaData.this.minimum) {
                stringArray[0] = NumberMetaData.this.getName() + ": value " + l + " is less than the minimum" + (Long)NumberMetaData.this.minimum;
                return false;
            }
            return true;
        }
    }

    private class IntegerRangeValidator
    implements Validator {
        private IntegerRangeValidator() {
        }

        public boolean validate(Object object, Locale locale, String[] stringArray) {
            int n = (Integer)object;
            if (NumberMetaData.this.maximum != null && n > (Integer)NumberMetaData.this.maximum) {
                stringArray[0] = NumberMetaData.this.getName() + ": value " + n + " exceeds maximum " + (Integer)NumberMetaData.this.maximum;
                return false;
            }
            if (NumberMetaData.this.minimum != null && n < (Integer)NumberMetaData.this.minimum) {
                stringArray[0] = NumberMetaData.this.getName() + ": value " + n + " is less than the minimum" + (Integer)NumberMetaData.this.minimum;
                return false;
            }
            return true;
        }
    }
}

