/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.binding.DefaultDataModel;
import org.jdesktop.binding.metadata.MetaData;
import org.jdesktop.binding.metadata.NumberMetaData;

public class JavaBeanDataModel
extends DefaultDataModel {
    private BeanInfo info;
    private Class beanClass;
    private Object bean;
    private static final Map<Class, Class> primitivesToBoxed = new HashMap<Class, Class>();
    public PropertyChangeListener propertyChangeListener;

    public JavaBeanDataModel(Class clazz) throws IntrospectionException {
        this(clazz, null);
    }

    public JavaBeanDataModel(Object object) throws IntrospectionException {
        this(object.getClass(), object);
    }

    public JavaBeanDataModel(Class clazz, Object object) throws IntrospectionException {
        this(clazz, object, null);
    }

    public JavaBeanDataModel(Class clazz, Object object, MetaData[] metaDataArray) throws IntrospectionException {
        this.beanClass = clazz;
        this.createDefaultMetaData(clazz, metaDataArray);
        this.setJavaBean(object);
    }

    private void createDefaultMetaData(Class clazz, MetaData[] metaDataArray) throws IntrospectionException {
        this.info = Introspector.getBeanInfo(clazz);
        boolean bl = false;
        if (metaDataArray == null) {
            PropertyDescriptor[] propertyDescriptorArray = this.info.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                bl = bl || propertyDescriptor.isBound();
                MetaData metaData = this.createMetaData(propertyDescriptor);
                if (metaData == null) continue;
                this.addField(metaData);
            }
        } else {
            for (int i = 0; i < metaDataArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(metaDataArray[i].getName());
                if (propertyDescriptor == null) continue;
                bl = bl || propertyDescriptor.isBound();
                this.addField(metaDataArray[i]);
            }
        }
        if (bl) {
            this.initPropertyChangeListener();
        }
    }

    private MetaData createMetaData(PropertyDescriptor propertyDescriptor) {
        MetaData metaData = null;
        if (propertyDescriptor.getPropertyType() != null) {
            if (Number.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                metaData = new NumberMetaData(propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), propertyDescriptor.getDisplayName());
            } else if (this.isNumberType(propertyDescriptor)) {
                metaData = new NumberMetaData(propertyDescriptor.getName(), primitivesToBoxed.get(propertyDescriptor.getPropertyType()), propertyDescriptor.getDisplayName());
                metaData.setRequired(true);
            } else {
                Class clazz = propertyDescriptor.getPropertyType();
                if (primitivesToBoxed.get(clazz) != null) {
                    clazz = primitivesToBoxed.get(clazz);
                }
                metaData = new MetaData(propertyDescriptor.getName(), clazz, propertyDescriptor.getDisplayName());
            }
        }
        return metaData;
    }

    private void initPropertyChangeListener() {
        if (this.propertyChangeListener != null) {
            return;
        }
        try {
            this.beanClass.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            this.beanClass.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JavaBeanDataModel.this.fireValueChanged(propertyChangeEvent.getPropertyName());
            }
        };
    }

    private boolean isNumberType(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor.getPropertyType() == Boolean.TYPE) {
            return false;
        }
        return propertyDescriptor.getPropertyType() == Integer.TYPE || propertyDescriptor.getPropertyType() == Long.TYPE || propertyDescriptor.getPropertyType() == Short.TYPE || propertyDescriptor.getPropertyType() == Byte.TYPE || propertyDescriptor.getPropertyType() == Float.TYPE || propertyDescriptor.getPropertyType() == Double.TYPE;
    }

    public void setJavaBean(Object object) {
        if (object != null && object.getClass() != this.beanClass) {
            throw new RuntimeException("ERROR: argument is not a " + this.beanClass.toString());
        }
        Object object2 = this.bean;
        this.removePropertyChangeListener(object2);
        this.bean = object;
        if (object != object2) {
            String[] stringArray = this.getFieldNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.fireValueChanged(stringArray[i]);
            }
        }
        this.addPropertyChangeListener(object);
    }

    private void addPropertyChangeListener(Object object) {
        if (this.propertyChangeListener == null || object == null) {
            return;
        }
        try {
            Method method = this.beanClass.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            method.invoke(object, this.propertyChangeListener);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void removePropertyChangeListener(Object object) {
        if (this.propertyChangeListener == null || object == null) {
            return;
        }
        try {
            Method method = this.beanClass.getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            method.invoke(object, this.propertyChangeListener);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object getJavaBean() {
        return this.bean;
    }

    public Object getValue(String string) {
        if (this.getJavaBean() == null) {
            return null;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
        Method method = propertyDescriptor.getReadMethod();
        if (method != null) {
            try {
                return method.invoke(this.getJavaBean(), new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    protected void setValueImpl(String string, Object object) {
        if (this.getJavaBean() == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(string);
        Method method = propertyDescriptor.getWriteMethod();
        if (method != null) {
            try {
                method.invoke(this.getJavaBean(), object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private PropertyDescriptor getPropertyDescriptor(String string) {
        PropertyDescriptor propertyDescriptor = null;
        PropertyDescriptor[] propertyDescriptorArray = this.info.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (!string.equals(propertyDescriptorArray[i].getName())) continue;
            propertyDescriptor = propertyDescriptorArray[i];
            break;
        }
        return propertyDescriptor;
    }

    static {
        primitivesToBoxed.put(Integer.TYPE, Integer.class);
        primitivesToBoxed.put(Long.TYPE, Long.class);
        primitivesToBoxed.put(Short.TYPE, Short.class);
        primitivesToBoxed.put(Byte.TYPE, Byte.class);
        primitivesToBoxed.put(Float.TYPE, Float.class);
        primitivesToBoxed.put(Double.TYPE, Double.class);
        primitivesToBoxed.put(Boolean.TYPE, Boolean.class);
    }
}

