/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.MnMachinePrecision;

class SinParameterTransformation {
    SinParameterTransformation() {
    }

    double int2ext(double value, double upper, double lower) {
        return lower + 0.5 * (upper - lower) * (Math.sin(value) + 1.0);
    }

    double ext2int(double value, double upper, double lower, MnMachinePrecision prec) {
        double piby2 = 2.0 * Math.atan(1.0);
        double distnn = 8.0 * Math.sqrt(prec.eps2());
        double vlimhi = piby2 - distnn;
        double vlimlo = -piby2 + distnn;
        double yy = 2.0 * (value - lower) / (upper - lower) - 1.0;
        double yy2 = yy * yy;
        if (yy2 > 1.0 - prec.eps2()) {
            if (yy < 0.0) {
                return vlimlo;
            }
            return vlimhi;
        }
        return Math.asin(yy);
    }

    double dInt2Ext(double value, double upper, double lower) {
        return 0.5 * Math.abs((upper - lower) * Math.cos(value));
    }
}

