/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.ArrayList;
import org.freehep.math.minuit.FunctionMinimum;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.MinimumBuilder;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MinimumSeed;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUtils;
import org.freehep.math.minuit.Pair;
import org.freehep.math.minuit.SimplexParameters;

class SimplexBuilder
implements MinimumBuilder {
    SimplexBuilder() {
    }

    public FunctionMinimum minimum(MnFcn mfcn, GradientCalculator gc2, MinimumSeed seed, MnStrategy strategy, int maxfcn, double minedm) {
        MnAlgebraicVector pbar;
        MnMachinePrecision prec = seed.precision();
        MnAlgebraicVector x = (MnAlgebraicVector)seed.parameters().vec().clone();
        MnAlgebraicVector step = MnUtils.mul(seed.gradient().gstep(), 10.0);
        int n = x.size();
        double wg = 1.0 / (double)n;
        double alpha = 1.0;
        double beta = 0.5;
        double gamma = 2.0;
        double rhomin = 4.0;
        double rhomax = 8.0;
        double rho1 = 1.0 + alpha;
        double rho2 = 1.0 + alpha * gamma;
        ArrayList<Pair> simpl = new ArrayList<Pair>(n + 1);
        simpl.add(new Pair(new Double(seed.fval()), x.clone()));
        int jl = 0;
        int jh = 0;
        double amin = seed.fval();
        double aming = seed.fval();
        for (int i = 0; i < n; ++i) {
            double dmin = 8.0 * prec.eps2() * (Math.abs(x.get(i)) + prec.eps2());
            if (step.get(i) < dmin) {
                step.set(i, dmin);
            }
            x.set(i, x.get(i) + step.get(i));
            double tmp = mfcn.valueOf(x);
            if (tmp < amin) {
                amin = tmp;
                jl = i + 1;
            }
            if (tmp > aming) {
                aming = tmp;
                jh = i + 1;
            }
            simpl.add(new Pair(new Double(tmp), x.clone()));
            x.set(i, x.get(i) - step.get(i));
        }
        SimplexParameters simplex = new SimplexParameters(simpl, jh, jl);
        do {
            MnAlgebraicVector prho;
            double yrho;
            double y2;
            MnAlgebraicVector pstst;
            double ystst;
            amin = (Double)simplex.get((int)jl).first;
            jl = simplex.jl();
            jh = simplex.jh();
            pbar = new MnAlgebraicVector(n);
            for (int i = 0; i < n + 1; ++i) {
                if (i == jh) continue;
                pbar = MnUtils.add(pbar, MnUtils.mul((MnAlgebraicVector)simplex.get((int)i).second, wg));
            }
            MnAlgebraicVector pstar = MnUtils.sub(MnUtils.mul(pbar, 1.0 + alpha), MnUtils.mul((MnAlgebraicVector)simplex.get((int)jh).second, alpha));
            double ystar = mfcn.valueOf(pstar);
            if (ystar > amin) {
                if (ystar < (Double)simplex.get((int)jh).first) {
                    simplex.update(ystar, pstar);
                    if (jh != simplex.jh()) continue;
                }
                if ((ystst = mfcn.valueOf(pstst = MnUtils.add(MnUtils.mul((MnAlgebraicVector)simplex.get((int)jh).second, beta), MnUtils.mul(pbar, 1.0 - beta)))) > (Double)simplex.get((int)jh).first) break;
                simplex.update(ystst, pstst);
                continue;
            }
            pstst = MnUtils.add(MnUtils.mul(pstar, gamma), MnUtils.mul(pbar, 1.0 - gamma));
            ystst = mfcn.valueOf(pstst);
            double y1 = (ystar - (Double)simplex.get((int)jh).first) * rho2;
            double rho = 0.5 * (rho2 * y1 - rho1 * (y2 = (ystst - (Double)simplex.get((int)jh).first) * rho1)) / (y1 - y2);
            if (rho < rhomin) {
                if (ystst < (Double)simplex.get((int)jl).first) {
                    simplex.update(ystst, pstst);
                    continue;
                }
                simplex.update(ystar, pstar);
                continue;
            }
            if (rho > rhomax) {
                rho = rhomax;
            }
            if ((yrho = mfcn.valueOf(prho = MnUtils.add(MnUtils.mul(pbar, rho), MnUtils.mul((MnAlgebraicVector)simplex.get((int)jh).second, 1.0 - rho)))) < (Double)simplex.get((int)jl).first && yrho < ystst) {
                simplex.update(yrho, prho);
                continue;
            }
            if (ystst < (Double)simplex.get((int)jl).first) {
                simplex.update(ystst, pstst);
                continue;
            }
            if (yrho > (Double)simplex.get((int)jl).first) {
                if (ystst < (Double)simplex.get((int)jl).first) {
                    simplex.update(ystst, pstst);
                    continue;
                }
                simplex.update(ystar, pstar);
                continue;
            }
            if (!(ystar > (Double)simplex.get((int)jh).first)) continue;
            pstst = MnUtils.add(MnUtils.mul((MnAlgebraicVector)simplex.get((int)jh).second, beta), MnUtils.mul(pbar, 1.0 - beta));
            ystst = mfcn.valueOf(pstst);
            if (ystst > (Double)simplex.get((int)jh).first) break;
            simplex.update(ystst, pstst);
        } while (simplex.edm() > minedm && mfcn.numOfCalls() < maxfcn);
        amin = (Double)simplex.get((int)jl).first;
        jl = simplex.jl();
        jh = simplex.jh();
        pbar = new MnAlgebraicVector(n);
        for (int i = 0; i < n + 1; ++i) {
            if (i == jh) continue;
            pbar = MnUtils.add(pbar, MnUtils.mul((MnAlgebraicVector)simplex.get((int)i).second, wg));
        }
        double ybar = mfcn.valueOf(pbar);
        if (ybar < amin) {
            simplex.update(ybar, pbar);
        } else {
            pbar = (MnAlgebraicVector)simplex.get((int)jl).second;
            ybar = (Double)simplex.get((int)jl).first;
        }
        MnAlgebraicVector dirin = simplex.dirin();
        dirin = MnUtils.mul(dirin, Math.sqrt(mfcn.errorDef() / simplex.edm()));
        MinimumState st = new MinimumState(new MinimumParameters(pbar, dirin, ybar), simplex.edm(), mfcn.numOfCalls());
        ArrayList<MinimumState> states = new ArrayList<MinimumState>(1);
        states.add(st);
        if (mfcn.numOfCalls() > maxfcn) {
            System.err.println("Simplex did not converge, #fcn calls exhausted.");
            return new FunctionMinimum(seed, states, mfcn.errorDef(), new FunctionMinimum.MnReachedCallLimit());
        }
        if (simplex.edm() > minedm) {
            System.err.println("Simplex did not converge, edm > minedm.");
            return new FunctionMinimum(seed, states, mfcn.errorDef(), new FunctionMinimum.MnAboveMaxEdm());
        }
        return new FunctionMinimum(seed, states, mfcn.errorDef());
    }
}

