/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.AnalyticalGradientCalculator;
import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.GradientCalculator;
import org.freehep.math.minuit.HessianGradientCalculator;
import org.freehep.math.minuit.InitialGradientCalculator;
import org.freehep.math.minuit.MinimumError;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MinimumSeed;
import org.freehep.math.minuit.MinimumSeedGenerator;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnHesse;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.NegativeG2LineSearch;
import org.freehep.math.minuit.Numerical2PGradientCalculator;
import org.freehep.math.minuit.Pair;
import org.freehep.math.minuit.VariableMetricEDMEstimator;

class MnSeedGenerator
implements MinimumSeedGenerator {
    static final /* synthetic */ boolean $assertionsDisabled;

    MnSeedGenerator() {
    }

    public MinimumSeed generate(MnFcn fcn, GradientCalculator gc2, MnUserParameterState st, MnStrategy stra) {
        int i;
        FunctionGradient dgrad;
        int n = st.variableParameters();
        MnMachinePrecision prec = st.precision();
        MnAlgebraicVector x = new MnAlgebraicVector(n);
        for (int i2 = 0; i2 < n; ++i2) {
            x.set(i2, (Double)st.intParameters().get(i2));
        }
        double fcnmin = fcn.valueOf(x);
        MinimumParameters pa = new MinimumParameters(x, fcnmin);
        if (gc2 instanceof AnalyticalGradientCalculator) {
            FunctionGradient ngrd;
            InitialGradientCalculator igc = new InitialGradientCalculator(fcn, st.trafo(), stra);
            FunctionGradient tmp = igc.gradient(pa);
            FunctionGradient grd = gc2.gradient(pa);
            Numerical2PGradientCalculator gc22 = new Numerical2PGradientCalculator(fcn, st.trafo(), stra);
            dgrad = ngrd = gc22.gradient(pa, grd);
            if (((AnalyticalGradientCalculator)gc2).checkGradient()) {
                boolean good = true;
                HessianGradientCalculator hgc = new HessianGradientCalculator(fcn, st.trafo(), new MnStrategy(2));
                Pair hgrd = hgc.deltaGradient(pa, dgrad);
                for (int i3 = 0; i3 < n; ++i3) {
                    if (!(Math.abs(((FunctionGradient)hgrd.first).grad().get(i3) - grd.grad().get(i3)) > ((MnAlgebraicVector)hgrd.second).get(i3))) continue;
                    System.err.println(" difference " + Math.abs(((FunctionGradient)hgrd.first).grad().get(i3) - grd.grad().get(i3)) + " " + ((MnAlgebraicVector)hgrd.second).get(i3));
                    System.err.println("gradient discrepancy of external parameter " + st.trafo().extOfInt(i3) + " (internal parameter " + i3 + ") too large.");
                    good = false;
                }
                if (!good) {
                    System.err.println("Minuit does not accept user specified gradient. To force acceptance, override 'virtual bool checkGradient() const' of FCNGradientBase.h in the derived class.");
                    if (!$assertionsDisabled && !good) {
                        throw new AssertionError();
                    }
                }
            }
        } else {
            dgrad = gc2.gradient(pa);
        }
        MnAlgebraicSymMatrix mat = new MnAlgebraicSymMatrix(n);
        double dcovar = 1.0;
        if (st.hasCovariance()) {
            for (i = 0; i < n; ++i) {
                for (int j = i; j < n; ++j) {
                    mat.set(i, j, st.intCovariance().get(i, j));
                }
            }
            dcovar = 0.0;
        } else {
            for (i = 0; i < n; ++i) {
                mat.set(i, i, Math.abs(dgrad.g2().get(i)) > prec.eps2() ? 1.0 / dgrad.g2().get(i) : 1.0);
            }
        }
        MinimumError err = new MinimumError(mat, dcovar);
        double edm = new VariableMetricEDMEstimator().estimate(dgrad, err);
        MinimumState state = new MinimumState(pa, err, dgrad, edm, fcn.numOfCalls());
        if (NegativeG2LineSearch.hasNegativeG2(dgrad, prec)) {
            if (gc2 instanceof AnalyticalGradientCalculator) {
                Numerical2PGradientCalculator ngc = new Numerical2PGradientCalculator(fcn, st.trafo(), stra);
                state = NegativeG2LineSearch.search(fcn, state, ngc, prec);
            } else {
                state = NegativeG2LineSearch.search(fcn, state, gc2, prec);
            }
        }
        if (stra.strategy() == 2 && !st.hasCovariance()) {
            MinimumState tmp = new MnHesse(stra).calculate(fcn, state, st.trafo(), 0);
            return new MinimumSeed(tmp, st.trafo());
        }
        return new MinimumSeed(state, st.trafo());
    }

    static {
        $assertionsDisabled = !MnSeedGenerator.class.desiredAssertionStatus();
    }
}

