/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.MinimumError;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnMachinePrecision;

abstract class MnPosDef {
    MnPosDef() {
    }

    static MinimumState test(MinimumState st, MnMachinePrecision prec) {
        MinimumError err = MnPosDef.test(st.error(), prec);
        return new MinimumState(st.parameters(), err, st.gradient(), st.edm(), st.nfcn());
    }

    static MinimumError test(MinimumError e, MnMachinePrecision prec) {
        MnAlgebraicSymMatrix err = (MnAlgebraicSymMatrix)e.invHessian().clone();
        if (err.size() == 1 && err.get(0, 0) < prec.eps()) {
            err.set(0, 0, 1.0);
            return new MinimumError(err, new MinimumError.MnMadePosDef());
        }
        if (err.size() == 1 && err.get(0, 0) > prec.eps()) {
            return e;
        }
        double epspdf = Math.max(1.0E-6, prec.eps2());
        double dgmin = err.get(0, 0);
        for (int i = 0; i < err.nrow(); ++i) {
            if (err.get(i, i) < prec.eps2()) {
                System.err.println("negative or zero diagonal element " + i + " in covariance matrix");
            }
            if (!(err.get(i, i) < dgmin)) continue;
            dgmin = err.get(i, i);
        }
        double dg = 0.0;
        if (dgmin < prec.eps2()) {
            dg = 1.0 + epspdf - dgmin;
            System.err.println("added " + dg + " to diagonal of error matrix");
        }
        MnAlgebraicVector s = new MnAlgebraicVector(err.nrow());
        MnAlgebraicSymMatrix p = new MnAlgebraicSymMatrix(err.nrow());
        for (int i = 0; i < err.nrow(); ++i) {
            err.set(i, i, err.get(i, i) + dg);
            if (err.get(i, i) < 0.0) {
                err.set(i, i, 1.0);
            }
            s.set(i, 1.0 / Math.sqrt(err.get(i, i)));
            for (int j = 0; j <= i; ++j) {
                p.set(i, j, err.get(i, j) * s.get(i) * s.get(j));
            }
        }
        MnAlgebraicVector eval = p.eigenvalues();
        double pmin = eval.get(0);
        double pmax = eval.get(eval.size() - 1);
        if (pmin > epspdf * (pmax = Math.max(Math.abs(pmax), 1.0))) {
            return e;
        }
        double padd = 0.001 * pmax - pmin;
        System.err.println("eigenvalues: ");
        for (int i = 0; i < err.nrow(); ++i) {
            err.set(i, i, err.get(i, i) * (1.0 + padd));
            System.err.println(eval.get(i));
        }
        System.err.println("matrix forced pos-def by adding " + padd + " to diagonal");
        return new MinimumError(err, new MinimumError.MnMadePosDef());
    }
}

