/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.FCNBase;
import org.freehep.math.minuit.FunctionGradient;
import org.freehep.math.minuit.HessianGradientCalculator;
import org.freehep.math.minuit.InitialGradientCalculator;
import org.freehep.math.minuit.MatrixInversionException;
import org.freehep.math.minuit.MinimumError;
import org.freehep.math.minuit.MinimumParameters;
import org.freehep.math.minuit.MinimumState;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnFcn;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnPosDef;
import org.freehep.math.minuit.MnStrategy;
import org.freehep.math.minuit.MnUserCovariance;
import org.freehep.math.minuit.MnUserFcn;
import org.freehep.math.minuit.MnUserParameterState;
import org.freehep.math.minuit.MnUserParameters;
import org.freehep.math.minuit.MnUserTransformation;
import org.freehep.math.minuit.Numerical2PGradientCalculator;
import org.freehep.math.minuit.VariableMetricEDMEstimator;

public class MnHesse {
    private MnStrategy theStrategy;

    public MnHesse() {
        this.theStrategy = new MnStrategy(1);
    }

    public MnHesse(int stra) {
        this.theStrategy = new MnStrategy(stra);
    }

    public MnHesse(MnStrategy stra) {
        this.theStrategy = stra;
    }

    public MnUserParameterState calculate(FCNBase fcn, double[] par, double[] err) {
        return this.calculate(fcn, par, err, 0);
    }

    public MnUserParameterState calculate(FCNBase fcn, double[] par, double[] err, int maxcalls) {
        return this.calculate(fcn, new MnUserParameterState(par, err), maxcalls);
    }

    public MnUserParameterState calculate(FCNBase fcn, double[] par, MnUserCovariance cov) {
        return this.calculate(fcn, par, cov, 0);
    }

    public MnUserParameterState calculate(FCNBase fcn, double[] par, MnUserCovariance cov, int maxcalls) {
        return this.calculate(fcn, new MnUserParameterState(par, cov), maxcalls);
    }

    public MnUserParameterState calculate(FCNBase fcn, MnUserParameters par) {
        return this.calculate(fcn, par, 0);
    }

    public MnUserParameterState calculate(FCNBase fcn, MnUserParameters par, int maxcalls) {
        return this.calculate(fcn, new MnUserParameterState(par), maxcalls);
    }

    public MnUserParameterState calculate(FCNBase fcn, MnUserParameters par, MnUserCovariance cov) {
        return this.calculate(fcn, par, 0);
    }

    public MnUserParameterState calculate(FCNBase fcn, MnUserParameters par, MnUserCovariance cov, int maxcalls) {
        return this.calculate(fcn, new MnUserParameterState(par, cov), maxcalls);
    }

    public MnUserParameterState calculate(FCNBase fcn, MnUserParameterState state, int maxcalls) {
        double errDef = 1.0;
        int n = state.variableParameters();
        MnUserFcn mfcn = new MnUserFcn(fcn, errDef, state.trafo());
        MnAlgebraicVector x = new MnAlgebraicVector(n);
        for (int i = 0; i < n; ++i) {
            x.set(i, (Double)state.intParameters().get(i));
        }
        double amin = mfcn.valueOf(x);
        Numerical2PGradientCalculator gc2 = new Numerical2PGradientCalculator(mfcn, state.trafo(), this.theStrategy);
        MinimumParameters par = new MinimumParameters(x, amin);
        FunctionGradient gra = gc2.gradient(par);
        MinimumState tmp = this.calculate(mfcn, new MinimumState(par, new MinimumError(new MnAlgebraicSymMatrix(n), 1.0), gra, state.edm(), state.nfcn()), state.trafo(), maxcalls);
        return new MnUserParameterState(tmp, errDef, state.trafo());
    }

    MinimumState calculate(MnFcn mfcn, MinimumState st, MnUserTransformation trafo, int maxcalls) {
        MnMachinePrecision prec = trafo.precision();
        double amin = mfcn.valueOf(st.vec());
        double aimsag = Math.sqrt(prec.eps2()) * (Math.abs(amin) + mfcn.errorDef());
        int n = st.parameters().vec().size();
        if (maxcalls == 0) {
            maxcalls = 200 + 100 * n + 5 * n * n;
        }
        MnAlgebraicSymMatrix vhmat = new MnAlgebraicSymMatrix(n);
        MnAlgebraicVector g2 = (MnAlgebraicVector)st.gradient().g2().clone();
        MnAlgebraicVector gst = (MnAlgebraicVector)st.gradient().gstep().clone();
        MnAlgebraicVector grd = (MnAlgebraicVector)st.gradient().grad().clone();
        MnAlgebraicVector dirin = (MnAlgebraicVector)st.gradient().gstep().clone();
        MnAlgebraicVector yy = new MnAlgebraicVector(n);
        if (st.gradient().isAnalytical()) {
            InitialGradientCalculator igc = new InitialGradientCalculator(mfcn, trafo, this.theStrategy);
            FunctionGradient tmp = igc.gradient(st.parameters());
            gst = (MnAlgebraicVector)tmp.gstep().clone();
            dirin = (MnAlgebraicVector)tmp.gstep().clone();
            g2 = (MnAlgebraicVector)tmp.g2().clone();
        }
        try {
            MnAlgebraicVector x = (MnAlgebraicVector)st.parameters().vec().clone();
            for (int i = 0; i < n; ++i) {
                double xtf = x.get(i);
                double dmin = 8.0 * prec.eps2() * (Math.abs(xtf) + prec.eps2());
                double d = Math.abs(gst.get(i));
                if (d < dmin) {
                    d = dmin;
                }
                for (int icyc = 0; icyc < this.ncycles(); ++icyc) {
                    int multpy;
                    double sag = 0.0;
                    double fs1 = 0.0;
                    double fs2 = 0.0;
                    for (multpy = 0; multpy < 5; ++multpy) {
                        x.set(i, xtf + d);
                        fs1 = mfcn.valueOf(x);
                        x.set(i, xtf - d);
                        fs2 = mfcn.valueOf(x);
                        x.set(i, xtf);
                        sag = 0.5 * (fs1 + fs2 - 2.0 * amin);
                        if (sag > prec.eps2()) break;
                        if (trafo.parameter(i).hasLimits()) {
                            if (d > 0.5) {
                                throw new MnHesseFailed("MnHesse: 2nd derivative zero for parameter");
                            }
                            if (!((d *= 10.0) > 0.5)) continue;
                            d = 0.51;
                            continue;
                        }
                        d *= 10.0;
                    }
                    if (multpy >= 5) {
                        throw new MnHesseFailed("MnHesse: 2nd derivative zero for parameter");
                    }
                    double g2bfor = g2.get(i);
                    g2.set(i, 2.0 * sag / (d * d));
                    grd.set(i, (fs1 - fs2) / (2.0 * d));
                    gst.set(i, d);
                    dirin.set(i, d);
                    yy.set(i, fs1);
                    double dlast = d;
                    d = Math.sqrt(2.0 * aimsag / Math.abs(g2.get(i)));
                    if (trafo.parameter(i).hasLimits()) {
                        d = Math.min(0.5, d);
                    }
                    if (d < dmin) {
                        d = dmin;
                    }
                    if (Math.abs((d - dlast) / d) < this.tolerstp() || Math.abs((g2.get(i) - g2bfor) / g2.get(i)) < this.tolerg2()) break;
                    d = Math.min(d, 10.0 * dlast);
                    d = Math.max(d, 0.1 * dlast);
                }
                vhmat.set(i, i, g2.get(i));
                if (mfcn.numOfCalls() - st.nfcn() <= maxcalls) continue;
                throw new MnHesseFailed("MnHesse: maximum number of allowed function calls exhausted.");
            }
            if (this.theStrategy.strategy() > 0) {
                HessianGradientCalculator hgc = new HessianGradientCalculator(mfcn, trafo, this.theStrategy);
                FunctionGradient gr = hgc.gradient(st.parameters(), new FunctionGradient(grd, g2, gst));
                grd = gr.grad();
            }
            for (int i = 0; i < n; ++i) {
                x.set(i, x.get(i) + dirin.get(i));
                for (int j = i + 1; j < n; ++j) {
                    x.set(j, x.get(j) + dirin.get(j));
                    double fs1 = mfcn.valueOf(x);
                    double elem = (fs1 + amin - yy.get(i) - yy.get(j)) / (dirin.get(i) * dirin.get(j));
                    vhmat.set(i, j, elem);
                    x.set(j, x.get(j) - dirin.get(j));
                }
                x.set(i, x.get(i) - dirin.get(i));
            }
            MinimumError tmp = MnPosDef.test(new MinimumError(vhmat, 1.0), prec);
            vhmat = tmp.invHessian();
            try {
                vhmat.invert();
            }
            catch (MatrixInversionException xx) {
                throw new MnHesseFailed("MnHesse: matrix inversion fails!");
            }
            FunctionGradient gr = new FunctionGradient(grd, g2, gst);
            if (tmp.isMadePosDef()) {
                System.err.println("MnHesse: matrix is invalid!");
                System.err.println("MnHesse: matrix is not pos. def.!");
                System.err.println("MnHesse: matrix was forced pos. def.");
                return new MinimumState(st.parameters(), new MinimumError(vhmat, new MinimumError.MnMadePosDef()), gr, st.edm(), mfcn.numOfCalls());
            }
            MinimumError err = new MinimumError(vhmat, 0.0);
            double edm = new VariableMetricEDMEstimator().estimate(gr, err);
            return new MinimumState(st.parameters(), err, gr, edm, mfcn.numOfCalls());
        }
        catch (MnHesseFailed x) {
            System.err.println(x.getMessage());
            System.err.println("MnHesse fails and will return diagonal matrix ");
            for (int j = 0; j < n; ++j) {
                double tmp = g2.get(j) < prec.eps2() ? 1.0 : 1.0 / g2.get(j);
                vhmat.set(j, j, tmp < prec.eps2() ? 1.0 : tmp);
            }
            return new MinimumState(st.parameters(), new MinimumError(vhmat, new MinimumError.MnHesseFailed()), st.gradient(), st.edm(), st.nfcn() + mfcn.numOfCalls());
        }
    }

    int ncycles() {
        return this.theStrategy.hessianNCycles();
    }

    double tolerstp() {
        return this.theStrategy.hessianStepTolerance();
    }

    double tolerg2() {
        return this.theStrategy.hessianG2Tolerance();
    }

    private class MnHesseFailed
    extends Exception {
        MnHesseFailed(String message) {
            super(message);
        }
    }
}

