/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import org.freehep.math.minuit.MatrixInversionException;
import org.freehep.math.minuit.MinimumError;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnUserCovariance;

abstract class MnCovarianceSqueeze {
    static final /* synthetic */ boolean $assertionsDisabled;

    MnCovarianceSqueeze() {
    }

    static MnUserCovariance squeeze(MnUserCovariance cov, int n) {
        if (!$assertionsDisabled && cov.nrow() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= cov.nrow()) {
            throw new AssertionError();
        }
        MnAlgebraicSymMatrix hess = new MnAlgebraicSymMatrix(cov.nrow());
        for (int i = 0; i < cov.nrow(); ++i) {
            for (int j = i; j < cov.nrow(); ++j) {
                hess.set(i, j, cov.get(i, j));
            }
        }
        try {
            hess.invert();
        }
        catch (MatrixInversionException x) {
            System.err.println("MnUserCovariance inversion failed; return diagonal matrix;");
            MnUserCovariance result = new MnUserCovariance(cov.nrow() - 1);
            int j = 0;
            for (int i = 0; i < cov.nrow(); ++i) {
                if (i == n) continue;
                result.set(j, j, cov.get(i, i));
                ++j;
            }
            return result;
        }
        MnAlgebraicSymMatrix squeezed = MnCovarianceSqueeze.squeeze(hess, n);
        try {
            squeezed.invert();
        }
        catch (MatrixInversionException x) {
            System.err.println("MnUserCovariance back-inversion failed; return diagonal matrix;");
            MnUserCovariance result = new MnUserCovariance(squeezed.nrow());
            for (int i = 0; i < squeezed.nrow(); ++i) {
                result.set(i, i, 1.0 / squeezed.get(i, i));
            }
            return result;
        }
        return new MnUserCovariance(squeezed.data(), squeezed.nrow());
    }

    static MinimumError squeeze(MinimumError err, int n) {
        MnAlgebraicSymMatrix hess = err.hessian();
        MnAlgebraicSymMatrix squeezed = MnCovarianceSqueeze.squeeze(hess, n);
        try {
            squeezed.invert();
        }
        catch (MatrixInversionException x) {
            System.err.println("MnCovarianceSqueeze: MinimumError inversion fails; return diagonal matrix.");
            MnAlgebraicSymMatrix tmp = new MnAlgebraicSymMatrix(squeezed.nrow());
            for (int i = 0; i < squeezed.nrow(); ++i) {
                tmp.set(i, i, 1.0 / squeezed.get(i, i));
            }
            return new MinimumError(tmp, new MinimumError.MnInvertFailed());
        }
        return new MinimumError(squeezed, err.dcovar());
    }

    static MnAlgebraicSymMatrix squeeze(MnAlgebraicSymMatrix hess, int n) {
        if (!$assertionsDisabled && hess.nrow() <= 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= hess.nrow()) {
            throw new AssertionError();
        }
        MnAlgebraicSymMatrix hs = new MnAlgebraicSymMatrix(hess.nrow() - 1);
        int j = 0;
        for (int i = 0; i < hess.nrow(); ++i) {
            if (i == n) continue;
            int l = j;
            for (int k = i; k < hess.nrow(); ++k) {
                if (k == n) continue;
                hs.set(j, l, hess.get(i, k));
                ++l;
            }
            ++j;
        }
        return hs;
    }

    static {
        $assertionsDisabled = !MnCovarianceSqueeze.class.desiredAssertionStatus();
    }
}

