/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.ps;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.FontPanel;
import org.freehep.graphicsio.exportchooser.ImageTypePanel;
import org.freehep.graphicsio.exportchooser.InfoPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;
import org.freehep.graphicsio.exportchooser.PageLayoutPanel;
import org.freehep.graphicsio.exportchooser.PageMarginPanel;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.freehep.util.UserProperties;

public abstract class AbstractPSExportFileType
extends AbstractExportFileType {
    protected static final String[] bitsList = new String[]{"1", "2", "4", "8"};
    protected OptionPanel preview;
    protected OptionCheckBox previewCheckBox;

    public boolean hasOptionPanel() {
        return true;
    }

    public String[] getMIMETypes() {
        return new String[]{"application/postscript"};
    }

    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, PSGraphics2D.getDefaultProperties());
        this.preview = new OptionPanel("Preview Image");
        this.previewCheckBox = new OptionCheckBox(options, PSGraphics2D.PREVIEW, "Include preview");
        this.preview.add("0 * * 1 [5 15 5 15] w", this.previewCheckBox);
        JLabel previewLabel = new JLabel("Bits per sample");
        this.preview.add("0 * [5 15 5 15] r", previewLabel);
        this.previewCheckBox.enables(previewLabel);
        OptionComboBox previewComboBox = new OptionComboBox(options, PSGraphics2D.PREVIEW_BITS, bitsList);
        this.preview.add("1 * [5 15 5 15] lw", previewComboBox);
        this.previewCheckBox.enables(previewComboBox);
        this.preview.setVisible(false);
        String rootKey = PSGraphics2D.class.getName();
        String abstractRootKey = AbstractVectorGraphicsIO.class.getName();
        InfoPanel infoPanel = new InfoPanel(options, rootKey, new String[]{"For", "Title"});
        OptionPanel leftPanel = new OptionPanel();
        leftPanel.add("0 * wt", new PageLayoutPanel(options, rootKey));
        leftPanel.add("0 * wt", new PageMarginPanel(options, rootKey));
        leftPanel.add("0 * wh", new JLabel());
        OptionPanel rightPanel = new OptionPanel();
        rightPanel.add("0 * wt", new BackgroundPanel(options, rootKey, false));
        rightPanel.add("0 * wt", this.preview);
        rightPanel.add("0 * wt", new ImageTypePanel(options, rootKey, new String[]{"Smallest Size", "ZLIB", "JPG"}));
        rightPanel.add("0 * wt", new FontPanel(options, rootKey, abstractRootKey));
        rightPanel.add("0 * wh", new JLabel());
        OptionPanel optionsPanel = new OptionPanel();
        optionsPanel.add("0 0 [5 5 5 5] wt", leftPanel);
        optionsPanel.add("1 0 [5 5 5 5] wt", rightPanel);
        optionsPanel.add("0 1 2 1 [5 5 5 5] wt", infoPanel);
        optionsPanel.add("0 * wh", new JLabel());
        return optionsPanel;
    }

    public VectorGraphics getGraphics(OutputStream os2, Component target) throws IOException {
        return new PSGraphics2D(os2, target);
    }

    public VectorGraphics getGraphics(OutputStream os2, Dimension dimension) throws IOException {
        return new PSGraphics2D(os2, dimension);
    }
}

