/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFPanel;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.util.export.ExportFileType;

public class EMFConverter {
    protected static void export(String type, String srcFileName, String destFileName) {
        try {
            List exportFileTypes = ExportFileType.getExportFileTypes(type);
            if (exportFileTypes == null || exportFileTypes.size() == 0) {
                System.out.println(type + " library is not available. check your classpath!");
                return;
            }
            ExportFileType exportFileType = (ExportFileType)exportFileTypes.get(0);
            EMFRenderer emfRenderer = new EMFRenderer(new EMFInputStream(new FileInputStream(srcFileName)));
            if (destFileName == null || destFileName.length() == 0) {
                int lastPointIndex = srcFileName.lastIndexOf(".");
                int lastSeparator1Index = srcFileName.lastIndexOf("/");
                int lastSeparator2Index = srcFileName.lastIndexOf("\\");
                if (lastSeparator1Index > lastPointIndex || lastSeparator2Index > lastPointIndex) {
                    destFileName = srcFileName + ".";
                } else if (lastPointIndex > -1) {
                    destFileName = srcFileName.substring(0, lastPointIndex + 1);
                }
                destFileName = destFileName + type.toLowerCase();
            }
            EMFPanel emfPanel = new EMFPanel();
            emfPanel.setRenderer(emfRenderer);
            exportFileType.exportToFile(new File(destFileName), (Component)emfPanel, (Component)emfPanel, null, "Freehep EMF converter");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            EMFConverter.export(args[1].substring(args[1].lastIndexOf(".") + 1), args[0], args[1]);
        }
        catch (Exception e) {
            System.out.println("usage: EMFConverter imput.emf output.extension");
        }
    }
}

