/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Plugin;
import org.freehep.application.studio.PluginInfo;
import org.freehep.application.studio.Studio;
import org.freehep.application.studio.pluginmanager.PluginManagerDialog;
import org.freehep.util.commanddispatcher.CommandGroup;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.xml.menus.XMLMenuBuilder;
import org.freehep.xml.util.ClassPathEntityResolver;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;

public class PluginManager
extends Plugin
implements Runnable {
    private boolean checkForPluginsAtStart;
    private String pluginURL;
    private List availablePlugins;

    protected void init() throws SAXException, IOException {
        Studio app = this.getApplication();
        Properties user = app.getUserProperties();
        this.pluginURL = user.getProperty("pluginURL");
        this.checkForPluginsAtStart = PropertyUtilities.getBoolean(user, "checkForPluginsAtStart", false);
        XMLMenuBuilder builder = app.getXMLMenuBuilder();
        URL xml = PluginManager.class.getResource("PluginManager.menus");
        builder.build(xml);
        app.getCommandTargetManager().add((CommandGroup)new Commands());
        if (this.checkForPluginsAtStart && this.pluginURL != null) {
            Thread t = new Thread(this);
            t.setDaemon(true);
            t.setPriority(5 - 1);
            t.start();
        }
    }

    List getAvailablePlugins() {
        return this.availablePlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            SAXBuilder builder = new SAXBuilder(true);
            builder.setEntityResolver(new ClassPathEntityResolver("plugin.dtd", Studio.class));
            URL url = new URL(this.pluginURL);
            InputStream in = url.openStream();
            try {
                this.availablePlugins = new ArrayList();
                Document doc = builder.build(in);
                Element root = doc.getRootElement();
                Iterator iter = root.getChildren().iterator();
                while (iter.hasNext()) {
                    Element node = (Element)iter.next();
                    PluginInfo plugin = new PluginInfo(node);
                    this.availablePlugins.add(plugin);
                }
                System.out.println("Done");
            }
            finally {
                in.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public class Commands
    extends CommandProcessor {
        public void onPluginManager() {
            PluginManagerDialog dlg = new PluginManagerDialog(PluginManager.this.getApplication(), PluginManager.this);
            dlg.pack();
            dlg.setModal(true);
            dlg.setLocationRelativeTo(PluginManager.this.getApplication());
            dlg.setTitle("Plugin Manager");
            dlg.setVisible(true);
        }
    }
}

