/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentPrintWriter
extends PrintWriter {
    private int indent = 0;
    private boolean indented = false;
    private String indentString;

    public IndentPrintWriter(Writer w) {
        super(w);
    }

    public void println(String s) {
        if (!this.indented) {
            this.doIndent();
        }
        super.println(s);
        this.indented = false;
    }

    public void print(String s) {
        if (!this.indented) {
            this.doIndent();
        }
        super.print(s);
    }

    public void println() {
        super.println();
        this.indented = false;
    }

    private void doIndent() {
        for (int i = 0; i < this.indent; ++i) {
            super.print(this.indentString);
        }
        this.indented = true;
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        --this.indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int level) {
        this.indent = level;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }
}

