/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.Global;
import ice.data.Server;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class FileManager {
    private static Logger logger = Logger.getLogger("FileLogger");
    private static FileManager reference;
    private String MOVE_DEVICES_FILE = "MoveDevicesDisplay.txt";
    private String STATUS_DEVICES_FILE = "DeviceStatusDisplay.txt";
    private String SERVERS_FILE = "servers.txt";
    private String XPEEK_SERVERS_FILE = "xpeekServers.txt";
    private String SESSION_FILE = "lastSession.txt";
    private String configPath = Global.getConfigPath();
    private String separator = Global.separator;

    private FileManager() {
    }

    public static synchronized FileManager getInstance() {
        if (reference == null) {
            reference = new FileManager();
        }
        return reference;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private synchronized boolean createConfigFile(String prefix, String filename) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/config/" + filename);
        if (is == null) {
            logger.debug("Input Stream is null for " + filename + ".  Possibly not running from JAR?");
            logger.debug("classpath:" + System.getProperty("java.class.path"));
            try {
                is = new FileInputStream(String.valueOf(System.getProperty("user.dir")) + this.separator + "config" + this.separator + filename);
            }
            catch (FileNotFoundException fnfe) {
                logger.fatal("Can't load default config file: " + filename + ".  Deployment must be corrupt:", fnfe);
                return false;
            }
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        File file = new File(String.valueOf(this.configPath) + prefix + filename);
        File dir = new File(this.configPath);
        logger.debug("directory exists?  " + String.valueOf(dir.exists()));
        if (!dir.exists()) {
            dir.mkdir();
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        String line = reader.readLine();
        logger.debug("line: " + line);
        while (line != null) {
            writer.append(line);
            writer.newLine();
            line = reader.readLine();
            logger.debug("line: " + line);
        }
        writer.flush();
        return true;
    }

    public synchronized TreeMap<String, Server> getServerList() throws IOException {
        String line;
        FileReader fileReader = this.getFileReader("", this.SERVERS_FILE);
        BufferedReader br = new BufferedReader(fileReader);
        Integer serverPort = null;
        TreeMap<String, Server> serverMap = new TreeMap<String, Server>();
        while ((line = br.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, ",");
            try {
                Server server;
                String serverName = tokenizer.nextToken().trim();
                serverName = this.parseOutQuotes(serverName);
                String serverAddress = tokenizer.nextToken().trim();
                if (tokenizer.hasMoreTokens()) {
                    serverPort = Integer.valueOf(tokenizer.nextToken().trim());
                    server = new Server(serverName, serverAddress, serverPort);
                } else {
                    server = new Server(serverName, serverAddress);
                }
                serverMap.put(serverName, server);
            }
            catch (NoSuchElementException nsee) {
                logger.warn("Bad line, skipping and moving on.");
            }
        }
        return serverMap;
    }

    public synchronized ArrayList<String> getXPeekServers() throws IOException {
        FileReader fileReader = this.getFileReader("", this.XPEEK_SERVERS_FILE);
        BufferedReader br = new BufferedReader(fileReader);
        ArrayList<String> serverList = new ArrayList<String>();
        String line = br.readLine();
        while (line != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                serverList.add(token);
            }
            line = br.readLine();
        }
        logger.debug("serverList: " + serverList.toString());
        return serverList;
    }

    public synchronized ArrayList<String> getStatusDevicesToDisplay() throws IOException {
        String line;
        String instrumentName = Global.getInstrumentName();
        FileReader fileReader = this.getFileReader(instrumentName, this.STATUS_DEVICES_FILE);
        BufferedReader br = new BufferedReader(fileReader);
        ArrayList<String> devices = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, ",");
            while (tokenizer.hasMoreElements()) {
                devices.add(tokenizer.nextToken().trim());
            }
        }
        return devices;
    }

    public synchronized TreeMap<String, ArrayList<String>> getMoveDevicesToDisplay() throws IOException {
        String line;
        FileReader fileReader = this.getFileReader(Global.getInstrumentName(), this.MOVE_DEVICES_FILE);
        BufferedReader br = new BufferedReader(fileReader);
        TreeMap<String, ArrayList<String>> deviceGroups = new TreeMap<String, ArrayList<String>>();
        while ((line = br.readLine()) != null) {
            String deviceName;
            StringTokenizer tokenizer = new StringTokenizer(line);
            String groupName = tokenizer.nextToken(":");
            ArrayList<String> newGroup = new ArrayList<String>();
            if (tokenizer.hasMoreElements()) {
                deviceName = tokenizer.nextToken(",").substring(1).trim();
                newGroup.add(deviceName);
            }
            while (tokenizer.hasMoreElements()) {
                deviceName = tokenizer.nextToken(",").trim();
                newGroup.add(deviceName);
            }
            deviceGroups.put(groupName, newGroup);
        }
        return deviceGroups;
    }

    private synchronized FileReader getFileReader(String prefix, String filename) throws IOException {
        File file = new File(String.valueOf(this.configPath) + prefix + filename);
        if (!file.exists()) {
            logger.debug("File " + this.configPath + prefix + filename + " does not exist.  Creating...");
            this.createConfigFile(prefix, filename);
            file = new File(String.valueOf(this.configPath) + prefix + filename);
        }
        return new FileReader(file);
    }

    private synchronized PrintWriter getPrintWriter(String prefix, String filename) throws IOException {
        File file = new File(String.valueOf(this.configPath) + prefix + filename);
        return new PrintWriter(file);
    }

    public synchronized ImageIcon getCancelBtn() {
        URL imgURL = this.getClass().getResource("/images/cancel.gif");
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        logger.error("Couldn't find cancel button");
        return null;
    }

    public synchronized ImageIcon getPauseBtn() {
        URL imgURL = this.getClass().getResource("/images/pause.gif");
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        logger.error("Couldn't find pause button");
        return null;
    }

    public synchronized ImageIcon getStopBtn() {
        URL imgURL = this.getClass().getResource("/images/stop.gif");
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        logger.error("Couldn't find stop button");
        return null;
    }

    private synchronized String parseOutQuotes(String string) {
        int location = string.indexOf("\"");
        while (location != -1) {
            string = String.valueOf(string.substring(0, location)) + string.substring(location + 1, string.length());
            location = string.indexOf("\"");
        }
        logger.debug("string: " + string);
        return string;
    }

    public synchronized void saveMoveDevices(TreeMap<String, ArrayList<String>> groupList) throws IOException {
        PrintWriter pw = this.getPrintWriter(Global.getInstrumentName(), this.MOVE_DEVICES_FILE);
        for (String groupName : groupList.keySet()) {
            String line = "";
            line = line.concat(String.valueOf(groupName) + ": ");
            ArrayList<String> deviceNames = groupList.get(groupName);
            int i = 0;
            while (i < deviceNames.size()) {
                line = line.concat(String.valueOf(deviceNames.get(i)) + ", ");
                ++i;
            }
            line = line.substring(0, line.length() - 2);
            logger.debug("line: " + line);
            pw.println(line);
        }
        pw.flush();
    }

    public synchronized void saveStatusDevices(ArrayList<String> devices) throws IOException {
        PrintWriter pw = this.getPrintWriter(Global.getInstrumentName(), this.STATUS_DEVICES_FILE);
        Iterator<String> iterator = devices.iterator();
        String line = "";
        while (iterator.hasNext()) {
            line = line.concat(String.valueOf(iterator.next()) + ", ");
        }
        line = line.substring(0, line.length() - 2);
        logger.debug("line: " + line);
        pw.println(line);
        pw.flush();
    }

    public synchronized File getPreferencesFile() throws IOException {
        File file = new File(String.valueOf(Global.getConfigPath()) + Global.separator + Global.getInstrumentName() + "preferences.properties");
        if (!file.exists()) {
            this.createConfigFile(Global.getInstrumentName(), "preferences.properties");
            file = new File(String.valueOf(Global.getConfigPath()) + Global.separator + Global.getInstrumentName() + "preferences.properties");
        }
        return file;
    }

    public synchronized File getDeviceOrderFile() throws IOException {
        File file = new File(String.valueOf(Global.getConfigPath()) + Global.separator + Global.getInstrumentName() + "-DeviceOrder.xml");
        if (!file.exists()) {
            this.createConfigFile(Global.getInstrumentName(), "-DeviceOrder.xml");
            file = new File(String.valueOf(Global.getConfigPath()) + Global.separator + Global.getInstrumentName() + "-DeviceOrder.xml");
        }
        return file;
    }

    public synchronized File getHelpFile() throws IOException {
        String configPath = Global.getConfigPath();
        String instrumentName = Global.getInstrumentName();
        String fileName = "Help.properties";
        File file = new File(String.valueOf(configPath) + Global.separator + instrumentName + fileName);
        if (!file.exists()) {
            this.createConfigFile(Global.getInstrumentName(), fileName);
            file = new File(String.valueOf(Global.getConfigPath()) + Global.separator + Global.getInstrumentName() + fileName);
        }
        return file;
    }
}

