/*
 * Decompiled with CFR 0.152.
 */
package ice.swing.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class CutCopySelection
implements Transferable {
    private Transferable delegate;
    private TransferType transferType;
    public static DataFlavor CUTCOPY_FLAVOR = new DataFlavor(CutCopySelection.class, CutCopySelection.class.getName());

    public CutCopySelection(Transferable delegate, TransferType transferType) {
        this.delegate = delegate;
        this.transferType = transferType;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Object toReturn = this;
        if (!flavor.equals(CUTCOPY_FLAVOR)) {
            toReturn = this.delegate.getTransferData(flavor);
        }
        return toReturn;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] delegateFlavors = this.delegate.getTransferDataFlavors();
        DataFlavor[] flavors = new DataFlavor[delegateFlavors.length + 1];
        System.arraycopy(delegateFlavors, 0, flavors, 0, delegateFlavors.length);
        flavors[flavors.length - 1] = CUTCOPY_FLAVOR;
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(CUTCOPY_FLAVOR) || this.delegate.isDataFlavorSupported(flavor);
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(TransferType transferType) {
        this.transferType = transferType;
    }

    public static enum TransferType {
        COPY,
        MOVE;

    }
}

