/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import javax.swing.JTable;

public class TableClipboardOwner
implements ClipboardOwner {
    public static final String CLIP_BOARD_OWNER = "ClipBoardOwner";
    private JTable table;
    private Object[] objects;
    private int[] rows;

    public TableClipboardOwner(JTable table) {
        this.table = table;
        this.rows = table.getSelectedRows();
        this.objects = new Object[this.rows.length];
        table.putClientProperty(CLIP_BOARD_OWNER, this);
        int i = 0;
        while (i < this.rows.length) {
            this.objects[i] = table.getValueAt(this.rows[i], 0);
            table.paintImmediately(table.getCellRect(this.rows[i], 0, false));
            ++i;
        }
    }

    public Object[] getObjects() {
        return this.objects;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        if (this.table.getClientProperty(CLIP_BOARD_OWNER) == this) {
            this.table.putClientProperty(CLIP_BOARD_OWNER, null);
        }
        int i = 0;
        while (i < this.rows.length) {
            this.table.paintImmediately(this.table.getCellRect(this.rows[i], 0, false));
            ++i;
        }
    }
}

