/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.event.DecimalLimitExceededEvent;
import ice.event.DecimalLimitExceededListener;
import ice.event.communication.EmptyDocumentListener;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;

public class IceTextField
extends JTextField
implements KeyListener,
DocumentListener {
    private static final int defaultNumberOfDecimalPlaces = 5;
    private int decimalPlaces;
    private boolean beep;
    private ArrayList<DecimalLimitExceededListener> decimalListener = new ArrayList();
    protected ArrayList<EmptyDocumentListener> emptyDocumentListeners;

    public IceTextField() {
        this(5, false);
        AbstractDocument document = (AbstractDocument)this.getDocument();
        document.addDocumentListener(this);
        this.emptyDocumentListeners = new ArrayList();
    }

    public IceTextField(int numberOfDecimalPlaces) {
        this(numberOfDecimalPlaces, false);
        AbstractDocument document = (AbstractDocument)this.getDocument();
        document.addDocumentListener(this);
    }

    public IceTextField(boolean isBeep) {
        this(5, isBeep);
        AbstractDocument document = (AbstractDocument)this.getDocument();
        document.addDocumentListener(this);
    }

    public IceTextField(int numberOfDecimalPlaces, boolean isBeep) {
        this.decimalPlaces = numberOfDecimalPlaces - 1;
        this.beep = isBeep;
        this.addKeyListener(this);
        AbstractDocument document = (AbstractDocument)this.getDocument();
        document.addDocumentListener(this);
    }

    @Override
    public void keyTyped(KeyEvent evt) {
        String stringText = this.getText();
        int caretPos = this.getCaretPosition();
        int dPlaces = 0;
        if (stringText.contains(".") && (dPlaces = stringText.length() - stringText.indexOf(46) - 1) > this.decimalPlaces && caretPos > stringText.indexOf(46)) {
            if (this.beep) {
                Toolkit.getDefaultToolkit().beep();
            }
            evt.consume();
            this.notifyDecimalExceededListeners(new DecimalLimitExceededEvent(this));
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    public void addDecimalLimitExceededListener(DecimalLimitExceededListener listener) {
        this.decimalListener.add(listener);
    }

    public void removeDecimalLimitExceededListener(DecimalLimitExceededListener listener) {
        this.decimalListener.remove(listener);
    }

    protected void notifyDecimalExceededListeners(DecimalLimitExceededEvent dlee) {
        Iterator<DecimalLimitExceededListener> iterator = this.decimalListener.iterator();
        while (iterator.hasNext()) {
            iterator.next().decimalExceeded(dlee);
        }
    }

    public boolean containsNumber() {
        try {
            Double.valueOf(this.getText());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public boolean containsNonNegativeNumber() {
        try {
            Double value = Double.valueOf(this.getText());
            return value >= 0.0;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public void addEmptyDocumentListener(EmptyDocumentListener l) {
        this.emptyDocumentListeners.add(l);
    }

    public void removeEmptyDocumentListener(EmptyDocumentListener l) {
        this.emptyDocumentListeners.remove(l);
    }

    protected void notifyEmptyDocumentListeners(EmptyDocumentListener.EmptyDocumentEvent e) {
        if (this.emptyDocumentListeners != null) {
            for (EmptyDocumentListener l : this.emptyDocumentListeners) {
                l.documentChanged(e);
            }
        }
    }

    protected void determineIfDocumentIsEmpty(DocumentEvent e) {
        int documentLength = -1;
        EmptyDocumentListener.EmptyDocumentState state = EmptyDocumentListener.EmptyDocumentState.EMPTY;
        EmptyDocumentListener.EmptyDocumentEvent event = null;
        documentLength = e.getDocument().getLength();
        if (documentLength > 0) {
            state = EmptyDocumentListener.EmptyDocumentState.HAS_TEXT;
        }
        event = new EmptyDocumentListener.EmptyDocumentEvent(this, state);
        this.notifyEmptyDocumentListeners(event);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.determineIfDocumentIsEmpty(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.determineIfDocumentIsEmpty(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.determineIfDocumentIsEmpty(e);
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }
}

