/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.IconManager;
import ice.data.InstalledDevice;
import ice.event.communication.DeviceValueChangedEvent;
import ice.swing.DeviceLabel;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class DeviceNameLabel
extends DeviceLabel {
    private ImageIcon countingForeverIcon;
    private ImageIcon errorIcon;
    private ImageIcon limitIcon;
    private ImageIcon movingIcon;
    private ImageIcon normalIcon;
    private ImageIcon unknownIcon;

    public DeviceNameLabel() {
    }

    public DeviceNameLabel(InstalledDevice device) {
        super(device, 25);
        this.countingForeverIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".countForever.16x16");
        this.errorIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".error.16x16");
        this.limitIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".limit.16x16");
        this.movingIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".moving.16x16");
        this.normalIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".normal.16x16");
        this.unknownIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".unknown.16x16");
        this.setFont(this.getFont().deriveFont(1));
        SwingUtilities.invokeLater(new DeviceLabel.UpdateLabel(device.getName(), this.getDeviceColor(device), null, this.determineIcon()));
    }

    @Override
    public void setText(String text) {
        super.setText(String.valueOf(text) + ":");
    }

    @Override
    public void actionPerformed(DeviceValueChangedEvent pce) {
        if (pce.getSource() != this.device) {
            return;
        }
        String propertyName = pce.getPropertyName();
        if (propertyName.equals("busy") || propertyName.equals("fixed") || propertyName.equals("status") || propertyName.equals("broken") || propertyName.equals("justBroke") || propertyName.equals("working") || propertyName.equals("justFixed")) {
            // empty if block
        }
        SwingUtilities.invokeLater((DeviceLabel)this.new DeviceLabel.UpdateLabel(this.determineIcon(), this.getDeviceColor(this.device)));
    }

    private ImageIcon determineIcon() {
        ImageIcon icon = this.unknownIcon;
        if (this.device == null) {
            return this.unknownIcon;
        }
        InstalledDevice.Status status = this.device.getStatus();
        if (this.device.isBroken().booleanValue()) {
            icon = this.errorIcon;
        } else if (this.device.isBusy()) {
            icon = this.movingIcon;
        } else if (status == InstalledDevice.Status.normal) {
            icon = this.normalIcon;
        } else if (status == InstalledDevice.Status.error) {
            icon = this.errorIcon;
        } else if (status == InstalledDevice.Status.atLimit) {
            icon = this.limitIcon;
        } else if (status == InstalledDevice.Status.countingForever) {
            icon = this.countingForeverIcon;
        }
        return icon;
    }

    @Override
    public void setDevice(InstalledDevice device) {
        super.setDevice(device);
        this.countingForeverIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".countForever.16x16");
        this.errorIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".error.16x16");
        this.limitIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".limit.16x16");
        this.movingIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".moving.16x16");
        this.normalIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".normal.16x16");
        this.unknownIcon = IconManager.getIcon("devices." + (Object)((Object)device.getType()) + ".unknown.16x16");
        SwingUtilities.invokeLater((DeviceLabel)this.new DeviceLabel.UpdateLabel(this.determineIcon(), this.getDeviceColor(device)));
    }

    public void removeDeviceIcon() {
        SwingUtilities.invokeLater(new DeviceLabel.UpdateLabel(null, null, null, null));
    }
}

