/*
 * Decompiled with CFR 0.152.
 */
package ice.swing;

import ice.Global;
import ice.data.InstalledDevice;
import ice.event.communication.DeviceValueChangedListener;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.apache.log4j.Logger;

public abstract class DeviceLabel
extends JLabel
implements DeviceValueChangedListener {
    protected InstalledDevice device;

    public DeviceLabel(InstalledDevice device, int numVisableCharacters) {
        super("");
        if (numVisableCharacters > 0) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int[] widths = fm.getWidths();
            int maxWidth = -1;
            int i = 0;
            while (i < widths.length) {
                maxWidth += widths[i];
                ++i;
            }
            Dimension d = new Dimension((maxWidth /= widths.length) * numVisableCharacters, fm.getHeight());
            this.setMaximumSize(d);
            this.setMinimumSize(d);
            this.setPreferredSize(d);
        }
        if (device != null) {
            this.device = device;
            try {
                this.device.addValueChangeListener(this);
            }
            catch (ICEListenerListExceptionBase e) {
                Logger.getLogger("DeviceLabel " + e);
            }
        }
    }

    public DeviceLabel() {
        super("N/A");
    }

    public InstalledDevice getDevice() {
        return this.device;
    }

    public void setDevice(InstalledDevice device) {
        if (this.device != null) {
            this.device.removeValueChangeListener(this);
        }
        this.device = device;
        try {
            this.device.addValueChangeListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("DeviceLabel " + e);
        }
    }

    protected Color getDeviceColor(InstalledDevice device) {
        if (device.isBusy()) {
            return Global.GREEN;
        }
        if (device.getStatus() == InstalledDevice.Status.atLimit) {
            return Color.BLUE;
        }
        if (device.isFixed()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    protected class UpdateLabel
    implements Runnable {
        private ImageIcon icon;
        private String text;
        private Color foregroundColor;
        private Color backgroundColor;

        public UpdateLabel(String text, Color foregroundColor, Color backgroundColor, ImageIcon icon) {
            this.text = text;
            this.foregroundColor = foregroundColor;
            this.backgroundColor = backgroundColor;
            this.icon = icon;
        }

        public UpdateLabel(ImageIcon icon, Color foregroundColor) {
            this(null, foregroundColor, null, icon);
        }

        public UpdateLabel(String text, ImageIcon icon) {
            this(text, null, null, icon);
        }

        public UpdateLabel(String text, Color foregroundColor) {
            this(text, foregroundColor, null, null);
        }

        public UpdateLabel(String text, Color foregroundColor, ImageIcon icon) {
            this(text, foregroundColor, null, icon);
        }

        public UpdateLabel(String text, Color foregroundColor, Color backgroundColor) {
            this(text, foregroundColor, backgroundColor, null);
        }

        @Override
        public void run() {
            if (this.text != null) {
                DeviceLabel.this.setText(this.text);
            }
            DeviceLabel.this.setIcon(this.icon);
            if (this.foregroundColor != null) {
                DeviceLabel.this.setForeground(this.foregroundColor);
            }
            if (this.backgroundColor != null) {
                DeviceLabel.this.setBackground(this.backgroundColor);
                DeviceLabel.this.setOpaque(true);
            } else {
                DeviceLabel.this.setOpaque(false);
            }
        }
    }
}

