/*
 * Decompiled with CFR 0.152.
 */
package ice.gui.tas.bt7.scan;

import ice.Controller;
import ice.communication.CommunicationManager;
import ice.event.communication.ClientMessageEvent;
import ice.event.communication.ClientMessageListener;
import ice.gui.core.IceDialog;
import ice.util.ICEListenerList.exception.ICEListenerListExceptionBase;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class DryRunScanWindow
extends IceDialog
implements ClientMessageListener,
ComponentListener {
    private JButton closeBtn;
    private Object[] options;
    private JTextArea results;
    private JDialog dryRunDialog;
    private JScrollPane dryRunScrollPane;
    private String data;
    private int locX;
    private int locY;
    private int width;
    private int height;
    private static DryRunScanWindow dryRunWindow;
    private Controller controller;

    private DryRunScanWindow() {
        this.initComponents();
    }

    public static DryRunScanWindow getInstance() {
        if (dryRunWindow == null) {
            dryRunWindow = new DryRunScanWindow();
        }
        return dryRunWindow;
    }

    private void initComponents() {
        this.locX = 0;
        this.locY = 0;
        this.width = 0;
        this.height = 0;
        this.closeBtn = new JButton("Close");
        this.options = new Object[1];
        this.options[0] = this.closeBtn;
        this.results = new JTextArea();
        this.results.setEditable(false);
        this.results.setBackground(Color.white);
        this.dryRunDialog = new JDialog();
        this.dryRunDialog.setTitle("Dry Run");
        this.dryRunDialog.setModal(false);
        this.dryRunDialog.setDefaultCloseOperation(0);
        this.dryRunDialog.addComponentListener(this);
        this.dryRunScrollPane = new JScrollPane(this.results, 22, 32);
        this.dryRunScrollPane.setPreferredSize(new Dimension(300, 300));
        this.dryRunScrollPane.setMinimumSize(new Dimension(20, 20));
        JOptionPane optionPane = new JOptionPane(this.dryRunScrollPane, -1, -1, null, this.options);
        this.dryRunDialog.setContentPane(optionPane);
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DryRunScanWindow.this.dryRunDialog.dispose();
            }
        });
        this.data = "N/A";
        this.controller = Controller.getReference();
        CommunicationManager comManager = this.controller.getCommMgr();
        try {
            comManager.addClientListener(this);
        }
        catch (ICEListenerListExceptionBase e) {
            Logger.getLogger("ErrorLogger").error("DryRunScanWindow.initComponents " + e);
        }
    }

    public void showDryRunScanResults() {
        this.results.setText("");
        this.results.append(this.data);
        this.dryRunDialog.pack();
        if (this.locX == 0) {
            this.dryRunDialog.setLocationRelativeTo(this.getParent());
        } else {
            this.dryRunDialog.setLocation(this.locX, this.locY);
        }
        if (this.width != 0) {
            this.dryRunDialog.setSize(this.width, this.height);
        }
        this.dryRunDialog.setVisible(true);
        this.dryRunDialog.toFront();
    }

    @Override
    public void actionPerformed(ClientMessageEvent ce) {
        String data1 = ce.getData();
        StringTokenizer tokenizer = new StringTokenizer(data1, ":");
        String firstToken = tokenizer.nextToken();
        if (firstToken.equalsIgnoreCase("Dry run scan")) {
            this.data = data1;
            this.results.setText("");
            this.results.append(this.data);
            this.showDryRunScanResults();
        }
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
        this.locX = arg0.getComponent().getX();
        this.locY = arg0.getComponent().getY();
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        this.width = arg0.getComponent().getWidth();
        this.height = arg0.getComponent().getHeight();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }
}

